/*
 ============================================================================
 Name		: BenchmarkApplication.cpp
 Author	  : Konstantin Knizhnik
 Copyright   : GigaBASE is freeware
 Description : Main application class
 ============================================================================
 */

// INCLUDE FILES
#include "Benchmark.hrh"
#include "BenchmarkDocument.h"
#include "BenchmarkApplication.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CBenchmarkApplication::CreateDocumentL()
// Creates CApaDocument object
// -----------------------------------------------------------------------------
//
CApaDocument* CBenchmarkApplication::CreateDocumentL()
	{
	// Create an Benchmark document, and return a pointer to it
	return CBenchmarkDocument::NewL(*this);
	}

// -----------------------------------------------------------------------------
// CBenchmarkApplication::AppDllUid()
// Returns application UID
// -----------------------------------------------------------------------------
//
TUid CBenchmarkApplication::AppDllUid() const
	{
	// Return the UID for the Benchmark application
	return KUidBenchmarkApp;
	}

// End of File
