/*
 * asf.h - header of asf.c
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Taken from asfinfo of Arpad Gereoffy <mplayer-users@mplayerhq.hu>.
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdio.h>

/*
typedef struct __attribute__((packed)) 
{
    long        biSize; // sizeof(BITMAPINFOHEADER)
    long        biWidth;
    long        biHeight;
    short       biPlanes; // unused
    short       biBitCount;
    long        biCompression; // fourcc of image
    long        biSizeImage;   // size of image. For uncompressed images
                               // ( biCompression 0 or 3 ) can be zero.


    long        biXPelsPerMeter; // unused
    long        biYPelsPerMeter; // unused
    long        biClrUsed;     // valid only for palettized images.
                               // Number of colors in palette.
    long        biClrImportant;
} BITMAPINFOHEADER;

typedef struct
{
  short   wFormatTag; // value that identifies compression format
  short   nChannels;
  long  nSamplesPerSec;
  long  nAvgBytesPerSec;
  short   nBlockAlign; // size of a data sample
  short   wBitsPerSample;
  short   cbSize;    // size of format-specific data
} WAVEFORMATEX;
*/

typedef struct __attribute__((packed)) {
  unsigned char guid[16];
  unsigned long long size;
} ASF_obj_header_t;

typedef struct __attribute__((packed)) {
  ASF_obj_header_t objh;
  unsigned int cno; // number of subchunks
  unsigned char v1; // unknown (0x01)
  unsigned char v2; // unknown (0x02)
} ASF_header_t;

/*typedef struct __attribute__((packed)) {
  unsigned char client[16]; // Client GUID
  unsigned long long file_size;
  unsigned long long creat_time; //File creation time FILETIME 8
  unsigned long long packets;    //Number of packets UINT64 8
  unsigned long long end_timestamp; //Timestamp of the end position UINT64 8
  unsigned long long duration;  //Duration of the playback UINT64 8
  unsigned long start_timestamp; //Timestamp of the start position UINT32 4
  unsigned long unk1; //Unknown, maybe reserved ( usually contains 0 ) UINT32 4
  unsigned long flags; //Unknown, maybe flags ( usually contains 2 ) UINT32 4
  unsigned long packetsize; //Size of packet, in bytes UINT32 4
  unsigned long packetsize2; //Size of packet ( confirm ) UINT32 4
  unsigned long frame_size; //Size of uncompressed video frame UINT32 4
} ASF_file_header_t;*/

typedef struct __attribute__((packed)) {
  unsigned char client[16]; // Client GUID
  unsigned long long file_size;
  unsigned char file_id[16]; // Client GUID
  unsigned long long creat_time; //File creation time FILETIME 8
  unsigned long long expdate;    //Number of packets UINT64 8
  unsigned long long end_timestamp; //Timestamp of the end position UINT64 8
  unsigned long long duration;  //Duration of the playback UINT64 8
  unsigned long flags; //Timestamp of the start position UINT32 4
  unsigned long min_bitrate;
  unsigned long max_bitrate;
  unsigned long avg_dusize;
  unsigned long max_dusize;
  unsigned long data_units;
  unsigned long streamcount;
/*
  unsigned long unk1; //Unknown, maybe reserved ( usually contains 0 ) UINT32 4
  unsigned long flags; //Unknown, maybe flags ( usually contains 2 ) UINT32 4
  unsigned long packetsize; //Size of packet, in bytes UINT32 4
  unsigned long packetsize2; //Size of packet ( confirm ) UINT32 4
  unsigned long frame_size; //Size of uncompressed video frame UINT32 4*/
} ASF_file_header_t;

typedef struct __attribute__((packed)) {
  unsigned char type[16]; // Stream type (audio/video) GUID 16
  unsigned char concealment[16]; // Audio error concealment type GUID 16
  unsigned long long unk1; // Unknown, maybe reserved ( usually contains 0 ) UINT64 8
  unsigned long type_size; //Total size of type-specific data UINT32 4
  unsigned long stream_size; //Size of stream-specific data UINT32 4
  unsigned short stream_no; //Stream number UINT16 2
  unsigned long unk2; //Unknown UINT32 4
} ASF_stream_header_t;

typedef struct __attribute__((packed)) {
  unsigned char streamno;
  unsigned char seq;
  unsigned long x;
  unsigned char flag;
} ASF_segmhdr_t;

extern int get_asf_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal,
			 char **act_artist, char **act_title);
