/*
 * avi.h - header of avi.c
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 * Copyright 2002, 2003 Balazs Dakay <dakayb@users.sourceforge.net>
 *
 * Taken from aviinfo of George Shunklin <gs@anime.org.ru>.
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *	Balazs Dakay <dakayb@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

typedef unsigned int DWORD;
typedef DWORD FOURCC;
typedef int LONG;
typedef unsigned char BYTE;
typedef short int WORD;

typedef struct {
  WORD wFormatTag;
  WORD nChannels;
  DWORD nSamplesPerSec;
  DWORD nAvgBytesPerSec;
  WORD nBlockAlign;
  WORD wBitsPerSample;
  WORD cbSize;
} WAVEFORMATEX;

#define SIGN_RIFF 0x46464952	//'RIFF'
#define SIGN_AVI_ 0x20495641	//'AVI '
#define SIGN_LIST 0x5453494C	//'LIST'
#define SIGN_HDRL 0x6C726468	//'hrdl'
#define SIGN_AVIH 0x68697661	//'avih'
#define SIGN_STRL 0x6C727473	//'strl'
#define SIGN_STRH 0x68727473	//'strh'
#define SIGN_STRF 0x66727473	//'strf'
#define SIGN_STRD 0x64727473	//'strd'
#define SIGN_VIDS 0x73646976	//'vids'
#define SIGN_AUDS 0x73647561	//'auds'

typedef struct {
  DWORD biSize;
  LONG biWidth;
  LONG biHeight;
  WORD biPlanes;
  WORD biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG biXPelsPerMeter;
  LONG biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} BITMAPINFOHEADER;

typedef struct {		// rgbq 
  BYTE rgbBlue;
  BYTE rgbGreen;
  BYTE rgbRed;
  BYTE rgbReserved;
} RGBQUAD;

typedef struct {		// bmi 
  BITMAPINFOHEADER bmiHeader;
  RGBQUAD bmiColors[1];
} BITMAPINFO;

typedef struct {
  DWORD dwMicroSecPerFrame;
  DWORD dwMaxBytesPerSec;
  DWORD dwReserved1;
  DWORD dwFlags;
  DWORD dwTotalFrames;
  DWORD dwInitialFrames;
  DWORD dwStreams;
  DWORD dwSuggestedBufferSize;
  DWORD dwWidth;
  DWORD dwHeight;
  DWORD dwScale;
  DWORD dwRate;
  DWORD dwStart;
  DWORD dwLength;
} MainAVIHeader;

typedef struct {
  FOURCC fccType;
  FOURCC fccHandler;
  DWORD dwFlags;
  DWORD dwReserved1;
  DWORD dwInitialFrames;
  DWORD dwScale;
  DWORD dwRate;
  DWORD dwStart;
  DWORD dwLength;
  DWORD dwSuggestedBufferSize;
  DWORD dwQuality;
  DWORD dwSampleSize;
} AVIStreamHeader;

typedef struct {
  AVIStreamHeader *Data_h;
  DWORD DataSize_h;
  union unknown {
    BITMAPINFOHEADER *v;
    WAVEFORMATEX *a;
  } Data_f;
  DWORD DataSize_f;
  void *Data_d;
  DWORD DataSize_d;
  void *Next;
} mem_chunk;

#define STATE_AVIH 1
#define STATE_STRH 2
#define STATE_NORM 0
#define STATE_STRF 3
#define STATE_RAW  4
#define STATE_STRD 5

typedef struct aviinfo_st {
  char *name;			// filename
  long size;			// file size in bytes
  long length;			// AVI length in seconds
  long bps;			// size / length
} aviinfo;

extern int get_avi_info (FILE * file, aviinfo * ai, int *act_sec, int *act_bitrate, int *act_nominal,
			 char **act_artist, char **act_title);
