/*
 * gini.h - global include for GINI
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "config.h"

#ifdef ENV_CYGWIN
#define MSG_DONTWAIT 0x40
#endif
#ifdef ENV_AIX
#define MSG_DONTWAIT 0x40
#endif

#define GINI_URL "(http://gini.sf.net/)"
#define GINI_COPYRIGHT "(c) 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>"
#define PROMPT "GINI> "

enum {
  STREAM_UNKNOWN = 0,
  STREAM_MP3,
  STREAM_OGG,
  STREAM_AVI,
  STREAM_MOV,
	STREAM_ASF,
	STREAM_REAL,
	NUM_STREAM_TYPES
};

enum {
  RESPONSE_306 = 0,
  RESPONSE_400,
  RESPONSE_403,
  RESPONSE_404,
  RESPONSE_504,
  RESPONSE_BAD_PASSWORD,
  RESPONSE_NO_BITRATE,
  RESPONSE_FEEDS_FULL,
  RESPONSE_UNKNOWN_TYPE,
  RESPONSE_BROKEN_HEADER,
	RESPONSE_KICKED,
  RESPONSE_CONSS_FULL,
  RESPONSES_NUM
};

char *const stream_types[NUM_STREAM_TYPES] = { "unknown", "MP3", "OGG", "AVI", "MOV", "ASF", "REAL"};
char *const mime_types[NUM_STREAM_TYPES] = {
	"application/x-unknown",
	"audio/mpeg",
	"application/x-ogg",
	"video/x-msvideo",
	"video/quicktime",
	"video/x-ms-asf",
	"audio/x-pn-realaudio"
};

typedef struct {
  int socket;
  u_long remote_ip;
  int init_state;
  int stream_type;
  int bitrate;
  u_char *mount;
  u_char *header;
  u_char *buffer;
  u_long skipfirst;
  int readed;
  u_long packets;
  u_long bytes;
  u_char *media_header;
  int media_header_len;
  u_char *x_ac_name;
  u_char *x_ac_genre;
  u_char *x_ac_url;
  u_char *x_ac_description;
  u_char *title_string;
  u_long file_size;
  u_long udpseq;
  int justreaded;
  int justwritten;
	u_long sec_start;
} feed_connection;

typedef struct {
  int socket;
  u_long remote_ip;
  int feed_conn;
  int init_state;
  u_long written;
  u_long allwritten;
  u_long packets;
  u_char *request;
  u_char *referer;
  u_char *useragent;
  u_int title_port;
  int title_socket;
  int justwritten;
	u_long sec_start;
} recv_connection;

typedef struct {
  int socket;
  u_long remote_ip;
  u_long readed;
  u_char *buffer;
  int justreaded;
} temp_connection;

typedef struct {
  int socket;
  u_long remote_ip;
  int init_state;
  u_long readed;
  u_long written;
  u_char *rbuffer;
  u_char *sbuffer;
  int justreaded;
  int justwritten;
	u_long sec_start;
	u_long sec_last;
} cons_connection;

typedef struct {
  int socket;
  u_long remote_ip;
  gchar *response_buffer;
  u_long written;
  int justwritten;
} term_connection;
