/*
 * real.h - header of real.c
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdio.h>


typedef struct {
    char oid[4];
    unsigned int size;
    unsigned short version;

    unsigned int file_version;
    unsigned int num_headers;
} rmhd;

typedef struct {
    char oid[4];
    unsigned int size;
    unsigned short version;

    unsigned int max_br;
    unsigned int avg_br;
    unsigned int max_ps;
    unsigned int avg_ps;
    unsigned int num_ps;
    unsigned int duration;
    unsigned int preroll;
    unsigned int index_offs;
    unsigned int data_offs;
    unsigned int num_streams;
    unsigned int flags;
} prophd;

typedef struct {
    char oid[4];
    unsigned int size;
    unsigned short version;

    unsigned short stream_no;
    unsigned int max_br;
    unsigned int avg_br;
    unsigned int max_ps;
    unsigned int avg_ps;
    unsigned int start_time;
    unsigned int preroll;
    unsigned int duration;
} mdprhd;

typedef struct {
    char oid[4];
    unsigned int size;
    unsigned short version;
} conthd;

extern int get_real_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal,
			 char **act_artist, char **act_title);
