/*
 * real.c - realmedia information functions for GINI
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include "real.h"

int a_sec;

void do_prop(prophd *h){
//    write(1,h->oid,4);
    if (h->version==0){
			a_sec=h->duration/1000;
    }
}

/*
void do_rmf(rmhd *h){
    write(1,h->oid,4);
    printf(" : len %d\n",htonl(h->size));
    if (h->version==0){
	printf(" fv: %d, nh: %d\n",h->file_version,h->num_headers);
    }
}

void do_mdpr(mdprhd *h){
    unsigned char xlen;
    int xoffs;
    unsigned char *b=h;

    write(1,h->oid,4);
    printf(" : len %d\n",htonl(h->size));
    if (h->version==0){
	printf(" sn: %d, mbr: %d, abr: %d, mps: %d, aps: %d, stt: %d, pr: %d, dur: %d\n",
    h->stream_no,
    h->max_br,
    h->avg_br,
    h->max_ps,
    h->avg_ps,
    h->start_time,
    h->preroll,
    h->duration);
    xoffs=0;
    xlen=b[40];
    if (xlen>0){
	write(1,b+41+xoffs,xlen);
	printf("\n");
    }
    xoffs+=xlen;
    xlen=b[41+xlen];
    if (xlen>0){
	write(1,b+42+xoffs,xlen);
	printf("\n");
    }
    }
}

void do_cont(conthd *h){
    unsigned short xlen;
    int xoffs;
    unsigned char *b=h;

    write(1,h->oid,4);
    printf(" : len %d\n",htonl(h->size));
    if (h->version==0){
	xoffs=0;
	xlen=b[10+xoffs];
	xlen*=256;
	xlen+=b[11+xoffs];
	if (xlen>0){
	    write(1,b+12+xoffs,xlen);
	    printf("\n");
	}
	xoffs+=xlen+2;
	xlen=b[12+xoffs];
	xlen*=256;
	xlen+=b[13+xoffs];
	if (xlen>0){
	    printf("%d\n",xlen);
	    write(1,b+14+xoffs,xlen);
	    printf("\n");
	}
	xoffs+=xlen+2;
	xlen=b[14+xoffs];
	xlen*=256;
	xlen+=b[15+xoffs];
	if (xlen>0){
	    write(1,b+16+xoffs,xlen);
	    printf("\n");
	}
    }
}

void do_data(rmhd *h){
    if (h->version==0){
    	write(1,h->oid,4);
	printf(" : %d\n",htonl(h->size));
    }
}
*/

void recurse (char *buf,unsigned int llen,int dep)
{
    char *tbuf=buf;
    unsigned int *len;
    char id[5];
    unsigned int cuccolt;
    id[4]=0;
    cuccolt=llen;
    
    while (cuccolt>0){
    if (isprint(tbuf[0])&&isprint(tbuf[1])&&isprint(tbuf[2])&&isprint(tbuf[3])){
/*	if (0==memcmp(tbuf,".RMF",4)){
	    do_rmf(tbuf);
	}
	if (0==memcmp(tbuf,"MDPR",4)){
	    do_mdpr(tbuf);
	}*/
	if (0==memcmp(tbuf,"PROP",4)){
	    do_prop((prophd *)tbuf);
	}
/*	if (0==memcmp(tbuf,"CONT",4)){
	    do_cont(tbuf);
	}
	if (0==memcmp(tbuf,"DATA",4)){
	    do_data(tbuf);
	}*/
	len=(int *)tbuf+4;
//	memcpy(id,tbuf,4);
/*	for (i=0;i<dep;i++){
	    printf(" ");
	}
	printf("%s : %d\n",id,htonl(*len));*/
	if (htonl(*len)>0){
	    recurse(tbuf+8,htonl(*len)-8,dep+1);
	}else{
	    return;
	}
	cuccolt-=htonl(*len);
	tbuf+=htonl(*len);
    }else{
	cuccolt=0;
    }
    }
}

int get_real_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal,
		  char **act_artist, char **act_title)
{
    unsigned int len,len2;
    char id[5];
    char *buf;
    int ret=0;
    
    id[4]=0;

    do {
			fread(id,4,1,file);
			fread(&len,4,1,file);
			len2=htonl(len);
			buf=malloc(len2);
			fread(buf+8,len2-8,1,file);
			memcpy(buf,id,4);
			memcpy(buf+4,&len,4);
			recurse (buf,len2,0);
			free(buf);
    } while (memcmp(id,"DATA",4));
		
		rewind(file);
		*act_sec=a_sec;
		*act_bitrate=*act_nominal=0;
    return ret;
}
