/*
 * util.c - various utility functions for GINI
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * URL encoding/decoding taken from PHP.
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <sys/time.h>
#include <sys/errno.h>
#include <ctype.h>

//#include "gini.h"
#include "util.h"

static gchar hexchars[] = "0123456789ABCDEF";

#define NUM_SIZES 4
static char *const sizes[NUM_SIZES] = { "B", "K", "M", "G" };

char *getheaders (char *hname, char *headers)
{
  char *t, *r;
  char *header = NULL;

  r = strstr (headers, hname);
  if (r != NULL) {
    if (' ' == r[strlen (hname)]) {
      r++;
    }
    t = strstr (r, "\r\n");
    if (NULL == t) {
      t = strchr (r, '\n');
    }
    if (t != NULL) {
      header = malloc (t - r - strlen (hname) + 1);
      header = strncpy (header, r + strlen (hname), t - r - strlen (hname));
      header[t - r - strlen (hname)] = '\0';
    }
  }
  return header;
}

char *getparameter (char *req, char *pname)
{
  char *t, *t2, *r;
  char *par = NULL;

  r = strstr (req, pname);
  if (r != NULL) {
    t = strstr (r, " ");
    t2 = strstr (r, "&");
    if (t2 != NULL) {
      if (t != NULL) {
	if (t2 < t) {
	  t = t2;
	}
      } else {
	t = t2;
      }
    }
    if (t != NULL) {
      par = malloc (t - r - strlen (pname) + 1);
      par = strncpy (par, r + strlen (pname), t - r - strlen (pname));
      par[t - r - strlen (pname)] = '\0';
    }
  }
  return par;
}

u_char *memfind (u_char * what, u_char * block, size_t len, int l)
{
  char *ret = NULL;
  size_t i;

  //printf(" %d < %d ",l,len);
  if (l <= len) {
    i = 0;
    while ((NULL == ret) && (i < len - 1 - l)) {
      if (!memcmp (what, block + i, l)) {
	ret = block + i;
      }
      i++;
    }
  }
  return ret;
}

static gint htoi (gchar * s)
{
  gint value;
  gint c;

  c = s[0];
  if (isupper (c)) {
    c = tolower (c);
  }
  value = (c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10) * 16;

  c = s[1];
  if (isupper (c)) {
    c = tolower (c);
  }
  value += c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10;
  return (value);
}

gchar *urldecode (gchar * str)
{
  gchar *dest = str;
  gchar *data = str;
  gint len = strlen (str);

  while (len--) {
    if ('+' == *data) {
      *dest = ' ';
    } else {
      if ('%' == *data && len >= 2 && isxdigit ((gint) * (data + 1)) && isxdigit ((gint) * (data + 2))) {
	*dest = (gchar) htoi (data + 1);
	data += 2;
	len -= 2;
      } else {
	*dest = *data;
      }
    }
    data++;
    dest++;
  }
  *dest = '\0';
  return (str);
}

gchar *urlencode (gchar * s)
{
  gint x, y, len;
  gchar *str;

  len = strlen (s);
  str = g_malloc (sizeof (gchar) * (3 * len + 1));
  for (x = 0, y = 0; len--; x++, y++) {
    str[y] = s[x];
    if (' ' == str[y]) {
      str[y] = '+';
    } else if ((str[y] < '0' && str[y] != '-' && str[y] != '.') ||
	       (str[y] < 'A' && str[y] > '9') ||
	       (str[y] > 'Z' && str[y] < 'a' && str[y] != '_') || (str[y] > 'z')) {
      str[y++] = '%';
      str[y++] = hexchars[s[x] >> 4];
      str[y] = hexchars[s[x] & 15];
    }
  }
  str[y] = '\0';
  return (str);
}

void resettimeout (struct timeval *tv)
{
  tv->tv_sec = 0;
#ifndef ENV_HURD
  tv->tv_usec = 5;
#else
  tv->tv_usec = 10000;
#endif
}

int urlparse (char *url, char **protocol, char **host, char **port, char **location)
{
  char *tmp, *tmpurl;
  int itmp;
  char *tprotocol, *thost, *tport, *tlocation;

  if (NULL != url) {
    tmpurl = url;
    tmp = strstr (tmpurl, "://");
    if ((NULL != tmp) && (tmp != tmpurl)) {
      itmp = tmp - tmpurl;
      tprotocol = malloc (itmp + 1);
      memcpy (tprotocol, tmpurl, itmp);
      tprotocol[itmp] = 0;
      tmpurl += itmp + 3;
      tmp = strchr (tmpurl, '/');
      if (NULL != tmp) {
	itmp = strlen (tmpurl) - (tmp - tmpurl);
	tlocation = malloc (itmp + 1);
	memcpy (tlocation, tmp, itmp);
	tlocation[itmp] = 0;
	itmp = tmp - tmpurl;
	tmp = malloc (itmp + 1);
	memcpy (tmp, tmpurl, itmp);
	tmp[itmp] = 0;
	tmpurl = tmp;
      } else {
	tlocation = strdup ("/");
	tmpurl = strdup (url);
      }
      tmp = strchr (tmpurl, ':');
      if (NULL != tmp) {
	itmp = strlen (tmpurl) - (tmp - tmpurl);
	tport = malloc (itmp);
	memcpy (tport, tmp + 1, itmp - 1);
	tport[itmp - 1] = 0;
	itmp = tmp - tmpurl;
	thost = malloc (itmp + 1);
	memcpy (thost, tmpurl, itmp);
	thost[itmp] = 0;
      } else {
	tport = strdup ("8000");
	thost = strdup (tmpurl);
      }
      free (tmpurl);
    }
    *protocol = tprotocol;
    *host = thost;
    *port = tport;
    *location = tlocation;
    return 1;
  }
  return 0;
}

char *get_data_pos (char *b)
{
  char *tb;
  char *ret = NULL;
  int diff = 0;

  tb = strstr (b, "\r\n\r\n");
  if (NULL == tb) {
    tb = strstr (b, "\n\n");
    diff = 2;
  } else {
    diff = 4;
  }
  if (tb) {
    ret = b + (tb - b) + diff;
  }
  return ret;
}

extern float convert_size (u_long bytes, char **code)
{
	float ret;
	int i;
	
	ret=bytes;
	
	i=0;
	while ((i<NUM_SIZES)&&(ret>999.9)){
		ret=ret/1024;
		i++;
	}
	
	if (i>=NUM_SIZES){
		i=NUM_SIZES-1;
	}
	
	*code=sizes[i];
	
	return ret;
}
