#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <golddig.h>

extern struct thing_s badguys[];  /* Array describing state of all */
extern int numbadguy;

/* These are the graphics cursors used for drawing the player at */
/* various times. */
GC standgc,angelgc,angelugc,angellgc,flygc,hang1gc,hang2gc,up1gc,up2gc;
GC left1gc,left2gc,right1gc,right2gc;

/* Redraw the player.  The graphics cursors all use the GXor function */
/* so they will not erase what is underneath. */
void draw_player()
{
  GC drawgc;
  register int lpos,code;
 
  /* Get position of level array of player */
  lpos = (player.xpos >> 1)*ysize + (player.ypos >> 1);
  /* Get the control code describing block underneath player */
  code = fast_lookup[level[lpos]].code;
  /* If the block is inactive, use the code for empty space */
  if((code & INACTIVE) && goldleft > 0)
    code = fast_lookup[SPACE].code;
 
  /* Compute the graphics cursor appropriate to the player's current */
  /* state */
  drawgc = NULL;
  if(angelleft) {
    if(player.ypos & 1)
      drawgc = angelugc;
    else if(player.xpos & 1)
      drawgc = angellgc;
    else
      drawgc = angelgc;
  }
  else {
    /* Check if player is hanging from a rope */
    if((player.ypos & 1) == 0) {
      if((code & DLEAVE) && ! (code & (ULEAVE | DFALL))) {
        if(player.xpos & 1)
          drawgc = hang2gc;
        else
          drawgc = hang1gc;
      }
    }
    else if((player.ypos & 1) && (code & DFALL))
      drawgc = flygc;
    
    if(drawgc == NULL)
      switch(player.dir) {
      case UP:    case DOWN:
        if(player.ypos & 1)
          drawgc = up2gc;
        else
          drawgc = up1gc;
        break;
      case LEFT:
        if(player.xpos & 1)
          drawgc = left2gc;
        else
          drawgc = left1gc;
        break;
      case RIGHT:
        if(player.xpos & 1)
          drawgc = right2gc;
        else
          drawgc = right1gc;
        break;
      case STAND:
        if(code & ULEAVE)
          drawgc = up1gc;
        else
          drawgc = standgc;
        break;
      default:
        drawgc = standgc;
      }
  }
  /* Fill the rectangle surrounding the player with the chosen */
  /* graphics cursor. */
  if(drawgc != NULL)
    XFillRectangle(disp,wind,drawgc,player.xpos << 3,player.ypos << 3,16,16);
}

/* Erase the player by redrawing the block(s) underneath him */
void drawmove_player()
{
  register int x,y; 
 
  /* Do not erase redraw player if it is not nessary */
  if(! player.redraw)
    return;
  /* Draw block covering at least half of player */
  x = player.xold;
  y = player.yold;
  draw_block(x >> 1,y >> 1);
  /* If player is offset horizontally, redraw block to the right */
  if(x & 1)
    draw_block((x >> 1) + 1,y >> 1);
  /* If player is offset vertically, redraw block below */
  if(y & 1)
    draw_block(x >> 1,(y >> 1) + 1);
 
  draw_player();
}
 
/* Redraw everything.  This routine is called whenever something major */
/* changes or the window is exposed. */
void redrawall()
{
  draw_level();
  draw_player();
  draw_badguys();
  XFlush(disp);
}
 
/* Move player one movement */
void move_player()
{
  register int i,code;
  static int linepos = 0;   /* Output script line position */
 
  /* Read in input script character */
  if(inscr != NULL) {
    /* If input repetition factor is down to 0, read the next order */
    /* from the script */
    if(incount == 0) {
      /* Loop through characters until a command is found */
      do {
        /* Read next script character */
        i = getc(inscr);
        /* Check for end of input script */
        if(i == EOF) {
          fclose(inscr);
          inscr = NULL;
          printf("Input script terminated.  Press any key to continue.\n");
          newlevel = 1;
          curtick --;   /* Reset clock back one tick */
          score = 0;
          draw_score();
          return;
        }
        /* If character is a repitition count, add it to incount */
        if(i >= 'a' && i <= 'z')
          incount = 26 * incount + (i - 'a');
      } while(i < '0' || i > '8');
      /* Set next input order */
      inorder = (enum directs) (i - '0');
      /* Make sure input count is at least 1 if no multiplier was */
      /* given */
      if(incount == 0)
        incount = 1;
    }
    curorder = inorder;     /* Set current order to input order */
    incount --;             /* Decrement input order counter */
  }
  /* Write out output script character */
  if(outscr != NULL) {
    /* If current order has not changed, just increment output order */
    /* count */
    if(outorder == curorder)
      outcount ++;
    else {
      /* Write output count multiplier */
      if(outcount > 1) {
        for(i=1;i <= outcount;i *= 26)
          continue;
        for(i /= 26;i > 0;i /= 26) {
          if(putc(((char) (outcount / i)) + 'a',outscr) == EOF) {
            perror("output script");
            exit(3);
          }
          outcount -= (outcount / i) * i;
        }
      }
      /* Write old output order */
      if(outorder != UNMOVE)
        if(putc(((char) outorder) + '0',outscr) == EOF) {
          perror("output script");
          exit(3);
        }
 
      /* Reset output order to new order */
      outorder = curorder;
      outcount = 1;
 
      /* Periodically insert newlines to make the output pretty */
      linepos ++;
      if(linepos == 30) {
        if(putc('\n',outscr) == EOF) {
          perror("output script");
          exit(3);
        }
        linepos = 0;
      }
    }
  }

  /* Attempt to move player according to his standing orders */
  if(angelleft)
	code = movedead(&player,curorder,-1);
  else
	code = movething(&player,curorder,-1);
  /* If digging completed, or if the player fell, and he was trying to */
  /* move in the same direction, change the current order to STAND */
  if(code == 4 || (code == 2 && curorder == player.dir))
    curorder = STAND;
  /* Redraw player if he dropped something (which will overwrite the */
  /* block) */
  if(code == 3)
    player.redraw = 1;
  /* If player is in the middle of a block, interesting things can */
  /* happen. */
  if((player.xpos & 1) == 0 && (player.ypos & 1) == 0)  {
    /* If the player has picked up a gold piece, consume it and */
    /* increment the score. */
    if(fast_lookup[player.hold].code & TREASURE) {
      player.hold = SPACE;
      score++;
      goldleft--;
      /* If that was the last gold piece, escape ladder and other */
      /* stuff may need to appear. */
      if(goldleft == 0) {
        regen_allow();      /* Regenerate the allowable movement array */
        redrawall();        /* Refresh the entire screen */
      }
      /* Redraw the score line */
      else
        draw_score();
    }
    /* Get the control code for the block direction underneath the */
    /* player */
    i = (player.xpos >> 1)*ysize + (player.ypos >> 1);
    code = fast_lookup[level[i]].code;
	/* If the player is an angel, and he is not inside a killer block, */
	/* decrement angelleft */
	if(angelleft > 0)
	  if(! --angelleft) {
		if((code & KILLIN) ||
		   overlap_badguy(player.xpos,player.ypos,-1))
		  ++angelleft;
		else
		  draw_score();
	  }
    /* If the control code shows an active UPLEVEL block, or the */
    /* player is at the top of the screen, and there is no more gold */
    /* left, goto the next level. */
    if((goldleft == 0 && 
    (player.ypos == 0 || (code & UPLEVEL))) ||
       ((code & UPLEVEL) && ! (code & INACTIVE)))  {
      /* Increment the level number */
      levelnum ++;
      /* Load the next level in if the current one is done */
      init_level();
      /* Redraw the level */
      redrawall();
      /* Flush all the many X windows operations out to the server.  This */
      /* is the only flush in all the operations in this procedure. */
      XFlush(disp);
      return;
    }
    /* If the block is a killer block, kill the player */
    if((code & KILLIN) && ! angelleft) {
      if (lives--) {
        angelleft = ANGELTIME;
        draw_score();
      }
      else
        died("was crushed");
    }
  }
  /* Do not let PUTDOWN order stay after movement has started */
  else if(curorder == PUTDOWN)
    curorder = STAND;
}
 
/* Move everything one movement (or less).  This is the basic function */
/* which is called on every timer signal. */
void moveall()
{
  /* Remember old position of player */
  player.xold = player.xpos;
  player.yold = player.ypos;
  /* Assume that the player does not need to be redrawn initially */
  player.redraw = 0;
  /* Do player movement */
  move_player();
  /* Do secondary movement if player is sped up */
  if(fast_lookup[player.hold].code & SPEED)
    move_player();
  /* Prevent time from advancing for bad guys if a TIMESTOP item is */
  /* held by player */
  if(! (fast_lookup[player.hold].code & TIMESTOP)) {
    /* Regenerate bad guys movement tree periodically */
    if(! (curtick & 0xf))
      regen_tree();
    /* Only move bad guys every other tick */
    if(! (curtick & 0x1))
      move_badguys();
  }
  /* Check if the player is overlapping one of the bad guys while not */
  /* holding armor. */
  if(! angelleft && ! (fast_lookup[player.hold].code & ARMOR) &&
     overlap_badguy(player.xpos,player.ypos,-1)) {
    if (lives--) {
      angelleft = ANGELTIME;
      draw_score();
    }
    else
      died("was eaten");
  }
  /* Redraw player if he moved.  Redraw occasionally anyway. */
  if(player.xpos != player.xold || player.ypos != player.yold ||
     (! (curtick & 0xf)))
    player.redraw = 1;
  /* Erase and draw player if necessary */
  drawmove_player();
  /* Flush all the many X windows operations out to the server.  This */
  /* is the only flush in all the operations in this procedure. */
  XFlush(disp);
}
