.\" Copyright (c) 1998-2003 Joe Marcus Clarke <marcus@marcuscom.com>
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\" $Id: gone.man,v 1.2 2003/10/13 05:58:59 marcus Exp $
.\"
.Dd October 13, 2003
.Dt GONE 1
.Os
.Sh NAME
.Nm gone
.Nd a terminal locking utility with many improvements over lock
.Sh SYNOPSIS
.Nm
.Op Fl bvpx
.Op Fl y | n
.Op Fl t Ar timeout
.Sh DESCRIPTION
.Nm
is a utility that locks a terminal with a password chosen by
the user.  
.Nm
will prompt the user for a password, then print the \fBgone\fR banner, 
then drop into the 
.Nm
shell.  From this shell, only a restricted set of commands can be run.  
.Nm
will also disallow messages by removing permissions on the parent tty.  
After the timeout period (10 minutes by default), 
.Nm 
will automatically log the user out. 
.Pp
If 
.Nm 
is installed setuid to root, then specifying the 
.Fl p
option will instruct gone to read the password from the system password
file/database instead of prompting the user.  Setuid'ing the program is
done by setting the environmental variable with_setuid to ``yes'' then
running configure.
.Pp
Options:
.Pp
.Bl -tag -width Fl
.It Fl b
Supress printing the
.Nm
banner.
.It Fl v
Print the version number and exit.
.It Fl p
Read the password from the system password database (must be setuid root
at install-time).
.It Fl x
Supress processing of extended shell commands (see the section on shell
commands below).
.It Fl y
By default
.Nm
turns messages off (see
.Xr mesg 1
).  This option will turn messages on.
.It Fl n
Same as the
.Fl y
option (deprecated).
.It Fl t Ar timeout
Specify an optional timeout value in minutes.  Default is 10 minutes.
If set to 0,
.Nm
will lock the terminal indefinitely.
.El
.Pp
.Nm
also accepts an optional string that is visible by using the 
.Xr w 1
command.  Use this, and other users can see why you are gone.
.Sh SHELL COMMANDS
Commands for the 
.Nm
shell (these commands can be abbreviated):
.Pp
.Bl -tag -width finger
.It Ar w
Invoke a UNIX
.Xr w 1
command (extended command).
.It Ar finger
Invoke a UNIX
.Xr finger 1
command.  When you type
.Ar finger
, you will be prompted for optional arguments (extended command).
.It Ar whoami
Invoke a UNIX
.Xr whoami 1
command (extended command).
.It Ar help
Print the
.Nm 
banner, and list of valid commands.
.It Ar cls
Clear the screen and print the
.Nm
banner.
.It Ar date
Invoke the UNIX
.Xr date 1
command (extended command).
.It Ar unlock
Unlock the terminal; prompts for unlock password.
.El
.Sh FILES
.Bl -tag -width _BINPATH_ -compact
.It Pa _BINPATH_
Gone binary application
.El
.Sh MINUTIAE
*
.Nm
will only run if the user is logged into a valid tty.  
.br
* Invoking a \fBSIGINT\fR, a \fBSIGSTP\fR, a \fBSIGQUIT\fR, or a \fBSIGKILL\fR 
will cause 
.Nm
to print the time remaining before the user is logged out.
.Sh BUGS
No known bugs, but I welcome any bug reports or comments to 
<marcus@marcuscom.com>
.Sh AUTHOR
Joe Marcus Clarke <marcus@marcuscom.com>
.Sh ACKNOWLEDGEMENTS
Dr. Burt "THE Doctor" Rosenberg, for motivating, for being a good
friend, and for having a great jump shot.
.br
Alexandra Loubeau, for using the damn thing.
.br
Jason Glick for giving me the quota to do most of the initial work...and
for Joe Satriani.
.br
Craig Kolthoff for installing it on jaguar....finally; and for giving me
a monster quota for FreeBSD.
.br
Blake Winton <bwinton@iname.com>, for contributing the patch for indefinite
terminal locking.
