/*gbe.h - declarations for the GNU Back End as used from GNU Pascal
  Copyright (C) 1997-2002 Free Software Foundation, Inc.

  Authors: Jan-Jaap van der Heijden <j.j.vanderheijden@student.utwente.nl>
           Peter Gerwinski <peter@gerwinski.de>
           Frank Heckenbach <frank@pascal.gnu.de>

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  GNU Pascal is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA. */

/* Allow for multiple inclusion. */
#ifndef _GBE_H_
#define _GBE_H_

#include "config.h"

/* Find out which version of the GBE we are using. */
#include "gcc-version.h"

/* Standard headers. */

#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <sys/stat.h>

#ifndef EGCS97
# include <ctype.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif

#if HAVE_UNISTD_H
# include <sys/types.h>
# include <unistd.h>
#endif

#if HAVE_FCNTL_H
# include <fcntl.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifndef EGCS97
# include "obstack.h"
#endif

/* The GNU Back End (GBE).
 *
 * Up to gcc-2.8.x, there were no real header files for the GBE.
 * With EGCS (gcc-2.95.x), one has started to write them.
 * With EGCS97 (gcc-2.97.x), they are essentially complete.
 * In the meantime, the GBE itself has changed substantially
 * (for instance obstacks have been dropped with EGCS97).
 *
 * In order to make GPC work with all those versions of the GBE,
 * we have to use all those `#ifdef's below and everywhere. */

/* Global stuff. */
#include "gansidecl.h"
#include "system.h"

#include "tree.h"      /* Tree nodes */
#include "gpc-tree.h"  /* Pascal-specific extensions to tree nodes */
#include "input.h"
#include "rtl.h"       /* Register Transfer Language */
#include "flags.h"
#include "output.h"
#include "expr.h"
#include "dwarfout.h"
#include "except.h"
#include "function.h"
#include "convert.h"

#include "toplev.h"
/* Missing in toplev.h */
extern int save_argc;
extern char **save_argv;
extern char *version_string;

#ifdef EGCS

#include "dbxout.h"
#include "cpplib.h"
#include "libiberty.h"

#ifndef EGCS97
/* Missing in tree.h */
extern struct obstack permanent_obstack;
extern struct obstack *current_obstack;

/* Missing in toplev.h */
extern int errorcount;
extern int sorrycount;
extern void (*print_error_function) PARAMS ((const char *));
extern void notice PARAMS ((const char *msgid, ...));
#endif

#else /* not EGCS */

/* This must be done after including any files */
#ifndef R_OK
# define R_OK 4
#endif

#ifndef EGCS
extern char *xmalloc PARAMS ((size_t));
#endif

/* dbxout.c */
extern void dbxout_set_type_status PARAMS ((tree, int)); /* GPC extension */

/* expmed.c */
extern void expand_inc PARAMS ((rtx, rtx));
extern void expand_dec PARAMS ((rtx, rtx));

/* function.c */
extern rtx nonlocal_goto_handler_slot;
extern rtx nonlocal_goto_stack_level;
extern tree nonlocal_labels;

/* print-tree.c */
extern void debug_tree PARAMS ((tree node));

/* stmt.c */
extern rtx tail_recursion_reentry;
extern void emit_jump PARAMS ((rtx));
extern void emit_nop PARAMS ((void));
extern void expand_computed_goto PARAMS ((tree));
extern rtx label_rtx PARAMS ((tree));

/* toplev.c */
extern char **save_argv;
extern char *progname;
extern int version_flag;
extern int errorcount;
extern int sorrycount;

extern void pedwarn PARAMS ((const char *, ...));
extern void warning PARAMS ((const char *, ...));
extern void error PARAMS ((const char *, ...));
extern void fatal PARAMS ((const char *, ...)) ATTRIBUTE_PRINTF_1 ATTRIBUTE_NORETURN;
extern void error_with_decl PARAMS ((tree, const char *, ...));
extern void rest_of_decl_compilation PARAMS ((tree, const char *, int, int));
extern void warning_with_file_and_line PARAMS ((const char *, int, char *, ...));
extern void (*print_error_function) PARAMS ((const char *));
extern void notice PARAMS ((const char *msgid, ...));

/* tree.c */
extern struct obstack permanent_obstack;
extern struct obstack *current_obstack;
extern int int_fits_type_p PARAMS ((tree, tree));
extern int really_constant_p PARAMS ((tree));
extern void pop_momentary_nofree PARAMS ((void));

/* GCC files not really part of the GBE. */

/* choose-temp.c */
extern char *choose_temp_base PARAMS ((void));

/* pexecute.c */
extern int pwait PARAMS ((int, int *, int));
extern int pexecute PARAMS ((const char *, char * const *, const char *,
                            const char *, char **, char **, int));

#endif /* not EGCS */

#endif /* _GBE_H_ */
