//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _CONSTANTS_H
#define _CONSTANTS_H 
#include "datatypes.h" 

#define TIMEOFFSET 631065600
#define UNDEF_FLOAT 1E25
#define UNDEF_DOUBLE 1E25

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// constants, mostly for the gramin protocol, are defined here
class Constants
{
   public:
      Constants::Constants(void);

   protected:
      static const g_byte

      Pid_Ack_Byte       =   6,
      Pid_Nak_Byte       =  21,
      Pid_Protocol_Array = 253,
      Pid_Product_Rqst   = 254,
      Pid_Product_Data   = 255,
      Pid_Command_Data   =  10,
      Pid_Xfer_Cmplt     =  12,
      Pid_Date_Time_Data =  14,
      Pid_Position_Data  =  17,
      Pid_Prx_Wpt_Data   =  19,
      Pid_Records        =  27,
      Pid_Rte_Hdr        =  29,
      Pid_Rte_Wpt_Data   =  30,
      Pid_Almanac_Data   =  31,
      Pid_Trk_Data       =  34,
      Pid_Wpt_Data       =  35,
      Pid_Pvt_Data       =  51,
      Pid_Rte_Link_Data  =  98,
      Pid_Trk_Hdr        =  99,
      
      Cmnd_Abort_Transfer =  0, /* abort current transfer */ 
      Cmnd_Transfer_Alm =  1, /* transfer almanac */ 
      Cmnd_Transfer_Posn =  2, /* transfer position */ 
      Cmnd_Transfer_Prx =  3, /* transfer proximity waypoints */
      Cmnd_Transfer_Rte =  4, /* transfer routes */ 
      Cmnd_Transfer_Time =  5, /* transfer time */ 
      Cmnd_Transfer_Trk =  6, /* transfer track log */ 
      Cmnd_Transfer_Wpt =  7, /* transfer waypoints */
      Cmnd_Turn_Off_Pwr =  8, /* turn off power */ 
      Cmnd_Start_Pvt_Data = 49, /* start transmitting PVT data */ 
      Cmnd_Stop_Pvt_Data = 50; /* stop transmitting PVT data */ 
};

}
#endif 
