//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "d103_wpt_type.h"
#include "constants.h"
#include <iomanip>


#include <iomanip>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


void D103_Wpt_Type::set(Packet pk)
{
   Wpt_Type::set(pk); // route or waypoint type will be set by Wpt_Type

   for(int i=0;i<6;i++) ident[i]=pk.data[i];
   lat=ltoh32(*(g_long*)(&pk.data[6]));
   lon=ltoh32(*(g_long*)(&pk.data[10]));
   for(int i=0;i<40;i++) cmnt[i]=pk.data[i+18];
   smbl=ltoh16(*(g_byte*)(&pk.data[58]));
   dspl=ltoh16(*(g_byte*)(&pk.data[59]));
   

   name = ident;
   comment = cmnt;
   latitude = s2d(lat);
   longitude = s2d(lon);
   symbol = number2symbol(smbl);
   altitude = UNDEF_FLOAT;

   switch(dspl)
   {
      case 0:  display_option="symbol+name";break;
      case 1:  display_option="symbol";break;
      case 2:  display_option="symbol+comment";break;
      default: display_option="symbol+name";
   }
}

Packet D103_Wpt_Type::makePacket(void)
{

   Packet pk = Wpt_Type::makePacket(); // route or waypoint type will be set by Wpt_Type

   lat = d2s(latitude);
   lon = d2s(longitude);


   for(int i=0;i<6;i++) pk.data[i]=32;
   for(int i=0; i<6&&i<(int(name.length())); i++) 
      pk.data[i]=name.c_str()[i];
   *(g_long*)(&pk.data[6])=htol32(g_long(lat));     // 
   *(g_long*)(&pk.data[10])=htol32(g_long(lon));    // 
   *(g_long*)(&pk.data[14])=htol32(g_long(0));      // 14-17 unused
   for(int i=0;i<40;i++)pk.data[i+18]=0;
   for(int i=0; i<40 && i<(int(comment.length())); i++) 
      pk.data[i+18]=comment.c_str()[i];
   smbl = symbol2number(symbol);      
      *(g_byte*)(&pk.data[58])=g_byte(smbl);
   dspl=0;             
      if(display_option=="symbol+name")dspl=0;
      if(display_option=="symbol")dspl=1;
      if(display_option=="symbol+comment")dspl=2;
      *(g_byte*)(&pk.data[59])=g_byte(dspl);

   pk.length=60; 

   return pk;
}

}
