//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "d109_wpt_type.h"
#include "constants.h"
#include <iomanip>

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

void D109_Wpt_Type::set(Packet pk)
{
   Wpt_Type::set(pk); // route or waypoint type will be set by Wpt_Type

//   g_byte dspl=*(g_byte*)(&pk.data[3]);         // display option
//   switch(dspl) {
//      case 0: display_option="symbol+name";break;
//      case 1: display_option="symbol";break;
//      case 2: display_option="symbol+comment";break;
//      default: display_option="symbol+name"; }
//
	display_option="symbol+name"; // What the Heck, always symbol+name


   g_int smbl=l2h16(*(g_int*)(&pk.data[4]));         // symbol
   symbol = number2symbol(smbl);
   
   g_long lat=l2h32(g_long(*(g_long*)(&pk.data[24])));             // lat
   latitude = s2d(lat);

   g_long lon=l2h32(*(g_long*)(&pk.data[28]));               // lon
   longitude = s2d(lon);

   g_float alt=l2hf(*(g_float*)(&pk.data[32]));            // alt
   altitude = alt;	

	char ident[51];for(int i=0; i<51;i++) ident[i]=0;
   int i=52;                                 // name 
   int start=i;
   for( ; pk.data[i]!=0; i++)                
      ident[i-start]=*(g_char*)(&pk.data[i]);
   name = string(ident);

	char cmnt[51];for(int i=0; i<51;i++) cmnt[i]=0;
   i++;                                       // comment
   start=i;
   for( ; pk.data[i]!=0; i++)                
      cmnt[i-start]=*(g_char*)(&pk.data[i]);
   comment = string(cmnt);
}

Packet D109_Wpt_Type::makePacket(void) 
{
	   Packet pk = Wpt_Type::makePacket(); // route or waypoint type will be set by Wpt_Type


      *(g_byte*)(&pk.data[0])= g_byte(0x01);    // dtype
      *(g_byte*)(&pk.data[1])= g_byte(0x00);    // wpt_class


//      *(g_byte*)(&pk.data[0])= g_byte(0x00);    // wpt_class
//      *(g_byte*)(&pk.data[1])= g_byte(0xff);    // color

//      g_byte dspl=0;                            // display (same as in 103)
//      if(display_option=="symbol+name")dspl=0;
//      if(display_option=="symbol")dspl=1;
//      if(display_option=="symbol+comment")dspl=2;
//      *(g_byte*)(&pk.data[2])=g_byte(dspl);
	      
		*(g_byte*)(&pk.data[2])=g_byte(0x1f); // What the Heck, symbol+name always

//    *(g_byte*)(&pk.data[3])= g_byte(0x60);  // attribute
      *(g_byte*)(&pk.data[3])= g_byte(0x70);  // attribute
/*		according to garmin attribute should be 0x70 but I have reports 
		that upload does not work with 0x70 but with 0x60 ??? */

      g_int smbl = symbol2number(symbol);               // symbol
      *(g_int*)(&pk.data[4])=htol16(smbl);

      const   g_byte subclass[18] = {       				// subclass
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
      for(int i=0;i<18;i++) *(g_byte*)(&pk.data[6+i])=subclass[i];

      g_long lat=d2s(latitude);
        *(g_long*)(&pk.data[24])=h2l32(g_long(lat));            // lat

      g_long lon=d2s(longitude);
        *(g_long*)(&pk.data[28])=h2l32(g_long(lon));            // lon 

      g_float alt=g_float(altitude);
        *(g_float*)(&pk.data[32])=h2lf(g_float(alt));			            // alt

		g_float dpth = 1.0e25;
        *(g_float*)(&pk.data[36])=g_float(dpth);         // dpth

		g_float dist = 0;
        *(g_float*)(&pk.data[40])=g_float(dist);         // dist

		g_char state[2];
		state[0] =' '; state[1]=' '; 								// state
			*(g_char*)(&pk.data[44])=state[0];	
			*(g_char*)(&pk.data[45])=state[1];	

		g_char cc[2];
		cc[0] =' '; cc[1]=' '; 										// country code
			*(g_char*)(&pk.data[46])=cc[0];	
			*(g_char*)(&pk.data[47])=cc[1];	

		g_longword ete=0xffffffff;

		*(g_longword*)(&pk.data[48])=h2l32(ete);         // outbound link 
			
		int i=52;
		int start=i;

	   for(; i-start<51 && i-start<(int(name.length())); i++)  // name
  	     pk.data[i]=name.c_str()[i-start];
		i++;*(g_byte*)(&pk.data[i])=0x00;

		start=i;
	   for(; i-start<51 && i-start<(int(comment.length())); i++)  // comment
  	     pk.data[i]=comment.c_str()[i-start];
		i++;*(g_byte*)(&pk.data[i])=0x00;

		i++;*(g_byte*)(&pk.data[i])=0x00; // facility
		i++;*(g_byte*)(&pk.data[i])=0x00; // city
		i++;*(g_byte*)(&pk.data[i])=0x00; // address
		i++;*(g_byte*)(&pk.data[i])=0x00; // cross road

      pk.length=i; 


   return pk;
}

}

