//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "gps.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;



int GPS::downloadDateTime(Date_Time_Type& datetime)
{
   if(openPort()>=0) {
      GarminGPS::downloadDateTime(datetime);
      GarminGPS::closePort();
      return 0; }
   return -1;
}


int GPS::downloadWaypoints(Waypointlist & wpl)
{
   if(openPort()>=0) {
      GarminGPS::downloadWaypoints(wpl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}

int GPS::downloadRoutes(Routelist& rtl)
{
   if(openPort()>=0) {
      GarminGPS::downloadRoutes(rtl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}

int GPS::uploadRoutes(Routelist& rtl)
{
   if(openPort()>=0) {
      GarminGPS::uploadRoutes(rtl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}


int GPS::downloadTracks(Tracklist& tkl)
{
   if(openPort()>=0) {
      GarminGPS::downloadTracks(tkl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}

int GPS::uploadTracks(Tracklist& tkl)
{
   if(openPort()>=0) {
      GarminGPS::uploadTracks(tkl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}


int GPS::uploadWaypoints(Waypointlist & wpl)
{
   if(openPort()>=0) {
      GarminGPS::uploadWaypoints(wpl);
      GarminGPS::closePort();
      return 0; }
   return -1;
}

void GPS::abortTransfer(void)
{
   if(openPort()>=0)
		GarminGPS::abortTransfer();
   GarminGPS::closePort();
}

void GPS::printTest(void)
{
   if(openPort()>=0)
      GarminGPS::printTest();
   GarminGPS::closePort();
}

void GPS::turnOff(void)
{
   if(openPort()>=0)
      GarminGPS::turnOff();
   GarminGPS::closePort();
}


}

