//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "wpt_type.h"
#include "newsymbols.h"



// ******************************************************************


namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

NewSymbols::NewSymbols(void)
{

	/// this is a list of the symbols possibly used by a garmin device
	// note that most garmin devices will only support a subset of these symbols
   newSymbolData _symbols[ANZ_NEWSYMBOLS] =
   {
       {"anchor",   0},  /* white anchor symbol              */    
       {"bell",   1},  /* white bell symbol                */
       {"diamond_grn",   2},  /* green diamond symbol             */     
       {"diamond_red",   3},  /* red diamond symbol               */     
       {"dive1",   4},  /* diver down flag 1                */    
       {"dive2",   5},  /* diver down flag 2                */
       {"dollar",   6},  /* white dollar symbol              */     
       {"fish",   7},  /* white fish symbol                */     
       {"fuel",   8},  /* white fuel symbol                */    
       {"horn",   9},  /* white horn symbol                */
       {"house",  10},  /* white house symbol               */     
       {"knife",  11},  /* white knife & fork symbol        */     
       {"light",  12},  /* white light symbol               */    
       {"mug",  13},  /* white mug symbol                 */
       {"skull",  14},  /* white skull and crossbones symbol*/     
       {"square_grn",  15},  /* green square symbol              */     
       {"square_red",  16},  /* red square symbol                */    
       {"wbuoy",  17},  /* white buoy waypoint symbol       */
       {"wpt_dot",  18},  /* waypoint dot                     */     
       {"wreck",  19},  /* white wreck symbol               */     
       {"null",  20},  /* null symbol (transparent)        */     
       {"mob",  21},  /* man overboard symbol             */
       {"buoy_ambr",  22},  /* amber map buoy symbol            */
       {"buoy_blck",  23},  /* black map buoy symbol            */     
       {"buoy_blue",  24},  /* blue map buoy symbol             */     
       {"buoy_grn",  25},  /* green map buoy symbol            */    
       {"buoy_grn_red",  26},  /* green/red map buoy symbol        */
       {"buoy_grn_wht",  27},  /* green/white map buoy symbol      */     
       {"buoy_orng",  28},  /* orange map buoy symbol           */     
       {"buoy_red",  29},  /* red map buoy symbol              */    
       {"buoy_red_grn",  30},  /* red/green map buoy symbol        */
       {"buoy_red_wht",  31},  /* red/white map buoy symbol        */     
       {"buoy_violet",  32},  /* violet map buoy symbol           */     
       {"buoy_wht",  33},  /* white map buoy symbol            */    
       {"buoy_wht_grn",  34},  /* white/green map buoy symbol      */
       {"buoy_wht_red",  35},  /* white/red map buoy symbol        */     
       {"dot",  36},  /* white dot symbol                 */     
       {"rbcn",  37},  /* radio beacon symbol              */     
       {"boat_ramp", 150},  /* boat ramp symbol                 */    
       {"camp", 151},  /* campground symbol                */     
       {"restrooms", 152},  /* restrooms symbol                 */     
       {"showers", 153},  /* shower symbol                    */     
       {"drinking_wtr", 154},  /* drinking water symbol            */    
       {"phone", 155},  /* telephone symbol                 */
       {"1st_aid", 156},  /* first aid symbol                 */     
       {"info", 157},  /* information symbol               */     
       {"parking", 158},  /* parking symbol                   */    
       {"park", 159},  /* park symbol                      */
       {"picnic", 160},  /* picnic symbol                    */     
       {"scenic", 161},  /* scenic area symbol               */     
       {"skiing", 162},  /* skiing symbol                    */    
       {"swimming", 163},  /* swimming symbol                  */
       {"dam", 164},  /* dam symbol                       */     
       {"controlled", 165},  /* controlled area symbol           */     
       {"danger", 166},  /* danger symbol                    */    
       {"restricted", 167},  /* restricted area symbol           */
       {"null_2", 168},  /* null symbol                      */     
       {"ball", 169},  /* ball symbol                      */ 
       {"car", 170},  /* car symbol                       */     
       {"deer", 171},  /* deer symbol                      */    
       {"shpng_cart", 172},  /* shopping cart symbol             */
       {"lodging", 173},  /* lodging symbol                   */     
       {"mine", 174},  /* mine symbol                      */     
       {"trail_head", 175},  /* trail head symbol                */    
       {"truck_stop", 176},  /* truck stop symbol                */
       {"user_exit", 177},  /* user exit symbol                 */     
       {"flag", 178},  /* flag symbol                      */     
       {"circle_x", 179},  /* circle with x in the center      */
       {"is_hwy", 8192},  /* interstate hwy symbol            */
       {"us_hwy", 8193},  /* us hwy symbol                    */     
       {"st_hwy", 8194},  /* state hwy symbol                 */     
       {"mi_mrkr", 8195},  /* mile marker symbol               */    
       {"trcbck", 8196},  /* TracBack (feet) symbol           */
       {"golf", 8197},  /* golf symbol                      */     
       {"sml_cty", 8198},  /* small city symbol                */     
       {"med_cty", 8199},  /* medium city symbol               */    
       {"lrg_cty", 8200},  /* large city symbol                */
       {"freeway", 8201},  /* intl freeway hwy symbol          */     
       {"ntl_hwy", 8202},  /* intl national hwy symbol         */     
       {"cap_cty", 8203},  /* capitol city symbol (star)       */     
       {"amuse_pk", 8204},  /* amusement park symbol            */    
       {"bowling", 8205},  /* bowling symbol                   */
       {"car_rental", 8206},  /* car rental symbol                */     
       {"car_repair", 8207},  /* car repair symbol                */     
       {"fastfood", 8208},  /* fast food symbol                 */    
       {"fitness", 8209},  /* fitness symbol                   */
       {"movie", 8210},  /* movie symbol                     */     
       {"museum", 8211},  /* museum symbol                    */     
       {"pharmacy", 8212},  /* pharmacy symbol                  */    
       {"pizza", 8213},  /* pizza symbol                     */
       {"post_ofc", 8214},  /* post office symbol               */     
       {"rv_park", 8215},  /* RV park symbol                   */     
       {"school", 8216},  /* school symbol                    */    
       {"stadium", 8217},  /* stadium symbol                   */
       {"store", 8218},  /* dept. store symbol               */     
       {"zoo", 8219},  /* zoo symbol                       */     
       {"gas_plus", 8220},  /* convenience store symbol         */    
       {"faces", 8221},  /* live theater symbol              */
       {"ramp_int", 8222},  /* ramp intersection symbol         */     
       {"st_int", 8223},  /* street intersection symbol       */     
       {"weigh_sttn", 8226},  /* inspection/weigh station symbol  */     
       {"toll_booth", 8227},  /* toll booth symbol                */    
       {"elev_pt", 8228},  /* elevation point symbol           */
       {"ex_no_srvc", 8229},  /* exit without services symbol     */     
       {"geo_place_mm", 8230},  /* Geographic place name}, man-made  */     
       {"geo_place_wtr", 8231},  /* Geographic place name}, water     */    
       {"geo_place_lnd", 8232},  /* Geographic place name}, land      */
       {"bridge", 8233},  /* bridge symbol                    */     
       {"building", 8234},  /* building symbol                  */     
       {"cemetery", 8235},  /* cemetery symbol                  */    
       {"church", 8236},  /* church symbol                    */
       {"civil", 8237},  /* civil location symbol            */     
       {"crossing", 8238},  /* crossing symbol                  */     
       {"hist_town", 8239},  /* historical town symbol           */    
       {"levee", 8240},  /* levee symbol                     */
       {"military", 8241},  /* military location symbol         */     
       {"oil_field", 8242},  /* oil field symbol                 */     
       {"tunnel", 8243},  /* tunnel symbol                    */    
       {"beach", 8244},  /* beach symbol                     */
       {"forest", 8245},  /* forest symbol                    */     
       {"summit", 8246},  /* summit symbol                    */     
       {"lrg_ramp_int", 8247},  /* large ramp intersection symbol   */    
       {"lrg_ex_no_srvc", 8248},  /* large exit without services smbl */
       {"badge", 8249},  /* police/official badge symbol     */     
       {"cards", 8250},  /* gambling/casino symbol           */
       {"snowski", 8251},  /* snow skiing symbol               */     
       {"iceskate", 8252},  /* ice skating symbol               */    
       {"wrecker", 8253},  /* tow truck (wrecker) symbol       */
       {"border", 8254},  /* border crossing (port of entry)  */     
       {"airport", 16384}, /* airport symbol                   */     
       {"int", 16385}, /* intersection symbol              */    
       {"ndb", 16386}, /* non-directional beacon symbol    */
       {"vor", 16387}, /* VHF omni-range symbol            */     
       {"heliport", 16388}, /* heliport symbol                  */     
       {"private", 16389}, /* private field symbol             */    
       {"soft_fld", 16390}, /* soft field symbol                */
       {"tall_tower", 16391}, /* tall tower symbol                */     
       {"short_tower", 16392}, /* short tower symbol               */     
       {"glider", 16393}, /* glider symbol                    */    
       {"ultralight", 16394}, /* ultralight symbol                */
       {"parachute", 16395}, /* parachute symbol                 */     
       {"vortac", 16396}, /* VOR/TACAN symbol                 */     
       {"vordme", 16397}, /* VOR-DME symbol                   */    
       {"faf", 16398}, /* first approach fix               */
       {"lom", 16399}, /* localizer outer marker           */     
       {"map", 16400}, /* missed approach point            */     
       {"tacan", 16401}, /* TACAN symbol                     */     
       {"seaplane", 16402},/* Seaplane Base                    */    
       {"geocache", 8255},  /* geocache symbol  */
       {"geocache_found", 8256},  /* geocache found symbol  */
   };

   for(int i=0;i<ANZ_NEWSYMBOLS;i++)
      symbols[i] = _symbols[i];

}

string NewSymbols::number2symbol(g_int n) const 
{
   for(int i=0;i<ANZ_NEWSYMBOLS;i++)
      if (symbols[i].n ==  n) return string(symbols[i].symbol);
   return string(symbols[0].symbol);

}

g_int NewSymbols::symbol2number(string s) const 
{
   for(int i=0;i<ANZ_NEWSYMBOLS;i++)
      if(string(symbols[i].symbol) == s) return symbols[i].n;
   return symbols[0].n;
}

}
