//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "posixserial.h"

#ifdef HAVE_TERMIOS_H


#include <fstream>

#define V_TIME 5  //  wait V_TIME for characters on serial port

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

// **************************************************************************
Serial::Serial(void)
{
   device = "/dev/ttyS1";   
   speed = "9600";
   fd = -1;

	#ifdef POSIX_SERIAL_IO_DEBUG
		char *envvar;
		envvar=getenv("GPSPOINT_POSIX_SERIAL_DEBUG_FILE");
		if(envvar)
		{	
			string debugfilename=getenv("GPSPOINT_POSIX_SERIAL_DEBUG_FILE");
			debugfile.open(debugfilename.c_str(),ofstream::app);
			debugfile <<"######################## posixserial constructor" << endl;
		}
	#endif
};


// **************************************************************************
Serial::~Serial()
{
   closePort();
	#ifdef POSIX_SERIAL_IO_DEBUG
		debugfile << "######################## posixserial destructor " << endl;
		debugfile.close();
	#endif
};

// **************************************************************************
void Serial::setDevice(string s)
{
   if(fd>0)
   {
      cerr << " don't change the device while port ist open " << endl;
      return;    
   }
   device = s;
};


// **************************************************************************
void Serial::setSpeed(string s)
{
   speed = s;
};


// **************************************************************************
void Serial::closePort()
{
  if (fd >= 0)
  {
    tcsetattr(fd, /*TCSAFLUSH*/ TCSADRAIN, &old_options);
    close(fd);
    if (lockfile != ""){ unlink(lockfile.c_str());}
    fd = -1;
  }
  return ;
};

// **************************************************************************

int Serial::writeByte(g_byte b)
{
	int err=0;
   if(fd>0)
      err = write(fd,&b,1);

	#ifdef POSIX_SERIAL_IO_DEBUG
	debugfile << "--> " <<  setw(3) << int(b) << " " << byteTrans(b) << " "  << err << " " << fd << endl ; 
	if(dle){if(byteTrans(b)=="ETX") debugfile << endl;}
	if(byteTrans(b)=="DLE")dle=true;else dle=false;
	#endif 

	return err;
}



int Serial::readByte(g_byte &b)
{
	int c = 0;
   if(fd>0) 
      c = read(fd,&b,1);

	#ifdef POSIX_SERIAL_IO_DEBUG
	debugfile << "<-- " <<  setw(3) << int(b) << " " << byteTrans(b) << " "  << c << " " << fd << endl ; 
	if(dle){if(byteTrans(b)=="ETX") debugfile << endl;}
	if(byteTrans(b)=="DLE")dle=true;else dle=false;
	#endif 

   return c; 
}

// **************************************************************************
int Serial::openPort()
{
     string lockdev = device.substr(device.find_last_of("/")+1);
     lockfile = "/var/lock/LCK.."+lockdev;


     if  ( stat(lockfile.c_str(),&filestat) >= 0) // check lock file
     {
        cerr << lockdev 
             << " is locked,\n\t remove " << lockfile << "  if stale  \n";
        fd = -4;
        lockfile = "";
        return  -1;
     }


   fd = open(device.c_str(),  O_RDWR | O_NOCTTY | O_NDELAY);
   if (fd <= 0) {
      cerr << "could not open " << device << " fd: " << fd << endl ;
      return -1; }
   else
   {
     fcntl(fd,F_SETFL,0);    
     tcgetattr(fd,&old_options); // get current options 
     memset (&options, 0,sizeof(options));
     options.c_cflag |= CRTSCTS;      // hadware flow on
     options.c_cflag  &= ~PARENB;    // no parity
     options.c_cflag  &= ~CSTOPB;    // one stopbit
     options.c_cflag  &= CSIZE;
     options.c_cflag |= CS8;        // 8N1
     options.c_cflag |= (CLOCAL | CREAD); //enable Localmode, receiver
     options.c_cc[VMIN] = 0;    // set min read chars if 0  VTIME takes over
     options.c_cc[VTIME] = V_TIME;   // wait x ms for charakter



     //options.c_cflag &= ~ ICANON; // canonical input 
     options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);

     unsigned int  baud = B9600;
     if(speed=="150")baud = B150;
     if(speed=="300")baud = B300;
     if(speed=="600")baud = B600;
     if(speed=="1200")baud = B1200;
     if(speed=="2400")baud = B2400;
     if(speed=="4800")baud = B4800; if(speed=="9600")baud = B9600;
     if(speed=="19200")baud = B19200;
     if(speed=="38400")baud = B38400;
     if(speed=="57600")baud = B57600;
     if(speed=="115200")baud = B115200;

     if(baud != B9600) cerr << "# Warning: linespeed is not garmin"
                            << "standart 9600 " << endl;

      err = cfsetospeed(&options, baud);
      if (err < 0 ) {    
         cerr << "could not set outputspeed"<< err << endl;
         closePort();
         return -1; }

      err = cfsetispeed(&options, baud);
      if (err < 0 ) { 
         cerr << "could not set inspeed "<< err << endl;
         closePort();
         return -1; }

      if (tcsetattr(fd,TCSAFLUSH, &options) < 0) { // set current options
        cerr << "could not set Portoptions " << strerror(errno) << endl;
        closePort();
        return -1; }
   }

   ofstream LCK(lockfile.c_str(),ios::out);            // lock the device
   LCK << "      "<< getpid() << " " 
       << "gpspoint" << " " << geteuid() << endl ;

   return 1;
};


#ifdef POSIX_SERIAL_IO_DEBUG
string Serial::byteTrans(int b)
{
	switch(b)
	{
		case   3: return string("ETX");
		case   6: return string("ACK");
		case  10: return string("pcd");
		case  12: return string("pxc");
		case  14: return string("ptd");
		case  16: return string("DLE");
 		case  17: return string("pod");
		case  21: return string("NAK");
		case 253: return string("ppa");
		case 254: return string("ppr");
		case 255: return string("ppd");
		default: return string("   ");
	}
}
#endif


}
#endif
