//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "track.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

Track::Track(const string &name) : trackheader(name) {
}


void Track::is(string is)
{
   size_t a=0,b=0;
   string s;
   do
   {
      b=is.find("\n",a+1);
      if(b==string::npos)
         s=is.substr(a,is.size()-a);
      else
          s=is.substr(a,b-a), a=b;

      setLine(s);

      if(readValue("type")==string("track")) {
//        cerr << " add track header ";
         trackheader << s;}
      

      if(readValue("type")==string("trackpoint")) {
//         cerr << " add trackpointt " ;
         Trk_Point_Type tp;
         tp << s;
         trackpoints.push_back(tp); }
   

   }while(b!=string::npos);
}


void Track::operator<<(string istr)
{
  is(istr); 
}

string Track::header(void)
{
   return trackheader.os();
}

string Track::operator[](int i)
{
   if(i<=int(trackpoints.size()))
      return trackpoints[i].os();
   return string("empty\n");
}

int Track::size(void) const
{
   return int(trackpoints.size());
}

string Track::os(void)
{
   
   string s="\n";
   if(size()<1) return s;

   s += trackheader.os();

   for(unsigned int i=0; i<trackpoints.size(); i++)
      s += trackpoints[i].os();
   
   s += " type=\"endtrack\"\n" ;

   return s;
}


void Track::os(ostream & o)
{
   o << os();
}

}
