//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "trk_hdr_type.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

string Trk_Hdr_Type::os(void)
{
   string s;
   s = "type=\"track\" " ;
   if(name!="") s=s+ "name=\""+ toGPD(name) + "\"   ";
   s += "\n";
   return s;
}

void Trk_Hdr_Type::os(ostream os)
{
   os << this->os();
}

Trk_Hdr_Type::Trk_Hdr_Type(const string &n) : name(n) {
}

Trk_Hdr_Type::Trk_Hdr_Type(void)
{
   clear();
}

void Trk_Hdr_Type::clear(void)
{
   name="";
};

void Trk_Hdr_Type::set(Packet p)
{
   cerr << " wpt_type not supportet ; you should not have gotten here " << endl;
}

Packet Trk_Hdr_Type::makePacket(void)
{
   cerr << " wpt_type not supportet ; you should not have gotten here " << endl;
   Packet p;
   return p;
}


void Trk_Hdr_Type::set(string s)
{
   clear();
   setLine(s);
   name = readValue("name");
}

void Trk_Hdr_Type::operator<<(string s)
{
   clear();
   set(s);
}

}
