/***************************************************************************
                   html32generator.cpp  -  description
                             -------------------
    begin                : 06.01.2007
    copyright            : (C) 2007 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <sstream>

#include "version.h"
#include "html32generator.h"

using namespace std;

namespace highlight {

Html32Generator::Html32Generator ():
  CodeGenerator(HTML32)
{
  newLineTag = "\n";
  spacer = " ";
  styleCommentOpen="/*";
  styleCommentClose="*/";
}

bool Html32Generator::initTheme(const string& themePath) {
   bool result = CodeGenerator::initTheme(themePath);

   styleTagOpen.push_back("");
   styleTagOpen.push_back(getOpenTag(docStyle.getStringStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getNumberStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getSingleLineCommentStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getCommentStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getEscapeCharStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getDirectiveStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getDirectiveStringStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getLineStyle()));
   styleTagOpen.push_back(getOpenTag(docStyle.getSymbolStyle()));

   styleTagClose.push_back("");
   styleTagClose.push_back(getCloseTag(docStyle.getStringStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getNumberStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getSingleLineCommentStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getCommentStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getEscapeCharStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getDirectiveStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getDirectiveStringStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getLineStyle()));
   styleTagClose.push_back(getCloseTag(docStyle.getSymbolStyle()));

   return result;
 }

string  Html32Generator::getOpenTag(const ElementStyle & elem) {
    ostringstream s;
  s << "<font color=\""<<"#"
    << elem.getColour().getRed(HTML)
    << elem.getColour().getGreen(HTML)
    << elem.getColour().getBlue(HTML)
    << "\">";
  if (elem.isBold()) s << "<b>";
  if (elem.isItalic()) s << "<i>";
  if (elem.isUnderline()) s << "<u>";
  return  s.str();
}

string  Html32Generator::getCloseTag(const ElementStyle & elem) {
  ostringstream s;
  if (elem.isUnderline()) s << "</u>";
  if (elem.isItalic()) s << "</i>";
  if (elem.isBold()) s << "</b>";
  s << "</font>";
  return  s.str();
}

string Html32Generator::getHeader()
{
  ostringstream os;
  os << "<html>\n"
     << "<head>";
  if (encodingDefined()){
        os << "<meta http-equiv=\"content-type\" content=\"text/html; charset="
           << encoding
           << "\">\n";
  }
  os <<"</head>"
     <<"<body bgcolor=\"#"
     << (docStyle.getBgColour().getRed(HTML))
     << (docStyle.getBgColour().getGreen(HTML))
     << (docStyle.getBgColour().getBlue(HTML))
     << "\" text=\"#"
     << (docStyle.getDefaultStyle().getColour().getRed(HTML))
     << (docStyle.getDefaultStyle().getColour().getGreen(HTML))
     << (docStyle.getDefaultStyle().getColour().getBlue(HTML))
     << "\">\n<pre><font face=\""<<this->getBaseFont()<<"\" size=\""<<this->getBaseFontSize()<<"pt\">";
  return os.str();
}

string Html32Generator::getFooter()
{
 ostringstream s;
 s <<"</font></pre>\n</body>\n</html>\n<!--HTML 3.2 generated by highlight "
   << HIGHLIGHT_VERSION << ", " <<  HIGHLIGHT_URL <<"-->\n";
 return s.str();
}

void Html32Generator::printBody()
{
  processRootState();
}

string Html32Generator::maskCharacter(unsigned char c)
{
  switch (c) {
    case '<' :
      return "&lt;";
      break;
    case '>' :
      return "&gt;";
      break;
    case '&' :
      return "&amp;";
      break;
    case '\"' :
      return "&quot;";
      break;

    //case '@' :
      //return "&#64;";
      //break;

    default :
      return string( 1, c );
    }
}
/*
string Html32Generator::getNewLine(){

  string nlStr;

  // set wrapping arrow if previous line was wrapped
 // if (preFormatter.isWrappedLine(lineNumber-1)) nlStr += "&#8629;";//"&crarr;";


  nlStr+="\n";
  return nlStr;
}
*/

string Html32Generator::getMatchingOpenTag(unsigned int styleID){
  return getOpenTag(docStyle.getKeywordStyle(langInfo.getKeywordClasses()[styleID]));
 }

string Html32Generator::getMatchingCloseTag(unsigned int styleID){
  return getCloseTag(docStyle.getKeywordStyle(langInfo.getKeywordClasses()[styleID]));
}

}
