#! /bin/sh
#
#ident "@(#)host:HOST-20040812:nscheck.sh,v 1.4 2003/12/04 03:41:18 woods Exp"
#
#	nscheck - check NS RRs at every parent NS
#
# A silly little script to pedantically check that every NS for the
# parent zone has the same records for the requested domain(s),
# checking for NS records by default
#
# For now the comparison must be done visually.
#
# Using '-a' should also show any glue records the parent nameservers
# may have -- however modern BIND-9 will return delegations in the
# AUTHORITY section and thus '-a' will fail and no glue records will
# ever be returned.
#
# The following is fun:
#
#	nscheck -V -P . version.bind
#
# it's the equivalent of:
#
#	nscheck -t txt -c ch -P . version.bind

# Exit codes from <sysexits.h>
#
EX_OK=0
EX_USAGE=64
EX_UNAVAILABLE=69

# default setup
#
flags="-r"
type="NS"
pzone=""
class=""
rc=""

argv0=$(basename $0)

while getopts a:c:dP:rt:uvVZ OPT; do
	case "$OPT" in
	d|u|v|Z|r)
		flags="-$OPT $flags"
		;;
	a)
		type="ANY"
		;;
	t)
		type="$OPTARG"
		;;
	c)
		class="-c $OPTARG"
		;;
	P)
		pzone="$OPTARG"
		;;
	V)
		type="TXT"
		class="-c CH"
		;;
	\?)
		exit $EX_USAGE
		;;
	esac
done
shift $(($OPTIND - 1))

for domain in $@; do
	if [ -z "$pzone" ]; then
		pzone=$(host -v -P $domain 2> /dev/null | fgrep 'parent zone:' | tail -1 | awk '{sub(/\)/, "", $NF); print $NF}')
	fi
	case "$pzone" in
	*.*)
		;;
	*)	
		pzone=${pzone}.
	esac
	nslist=$(host --canonskip -t NS $pzone | awk '{print $NF}')
	for ns in $nslist ; do
		echo ""
		case "$flags" in
		*-v*|*-d*)
			echo "========================================"
			;;
		esac
		echo "====> Checking $ns for $type records for $domain...."
		host $flags $class -t $type $domain $ns
		rc=${rc:-$?}
	done
done

exit $rc
