/* ѱ ̺귯 .
   Copyright (C) 2002, 2003, 2004 HRE  ׷

This file is part of Hangul Regular Expression Library (aka HRE).

HRE is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

HRE is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <string.h>

/* UTF8toUCS2
   converts UTF8 string to UCS2 array.  */
int
UTF8toUCS2 (char *src, int *ucs2)
{
  unsigned char c;
  int unicode;
  int count=0;
  int len;
  int i;
  
  len = strlen(src);
  for (i=0; i<len;) 
    {
      c = src[i]&0xe0;
      if (c < 0x80) 
	{
	  unicode = (int) src[i];
	  i++;
	}
      else if (c < 0xe0) 
	{
	  unicode = (int) src[i] & 0x1f;
	  i++;
	  unicode = unicode << 6;
	  unicode = unicode | ((int) src[i] & 0x3f);
	  i++;
	}
      else if (c < 0xf0) 
	{
	  unicode = (int) src[i] & 0x0f;
	  i++;
	  unicode = unicode << 6;
	  unicode = unicode | ((int) src[i] & 0x3f);
	  i++;
	  unicode = unicode << 6;
	  unicode = unicode | ((int) src[i] & 0x3f);
	  i++;
	}
      ucs2[count] = unicode;
      count++;
    }
  
  return count;
}

/* UCS2toUTF8
   converts UCS2 array to UTF8 string.  */
int 
UCS2toUTF8 (int *ucs2, int count, char *dst)
{
  int unicode;
  unsigned char bytes[4];
  int nbytes;
  int i, j;
  int len=0;
  
  for (i=0; i<count; i++) 
    {
      unicode = ucs2[i];
      if (unicode < 0x80) 
	{
	  nbytes = 1;
	  bytes[0] = unicode;
	} 
      else if (unicode < 0x800) 
	{
	  nbytes = 2;
	  bytes[1] = (unicode & 0x3f) | 0x80;
	  bytes[0] = (((unicode << 2) & 0xcf00) | 0xc000) >> 8;
	} 
      else 
	{
	  nbytes = 3;
	  bytes[2] = (unicode & 0x3f) | 0x80;
	  bytes[1] = (((unicode << 2) & 0x3f00) | 0x8000) >> 8;
	  bytes[0] = (((unicode << 4) & 0x3f0000) | 0xe00000) >> 16;
	}
      
      for (j=0; j<nbytes; j++) 
	{
	  dst[len] = bytes[j];
	  len++;
	}
    }
  dst[len] = '\0';
  return len;
}

/* ѱ ƴ Ѵ.  */
int
hre_ishangeul (str)
     const char *str;
{
  int fst = ((int) str[0]) & 0xff;
  int snd = ((int) str[1]) & 0xff;
  int thd = ((int) str[2]) & 0xff;
  int jf, js, jt;

  /* ڵ UTF-8 */
  if ((fst >> 4) == 14 
      && (snd >> 6) == 2
      && (thd >> 6) == 2)
    return 3;

  /*  */
  jf = (fst & 0x7f) >> 2;
  js = ((fst & 0x3) << 3) + ((snd & 0xe0) >> 5);
  jt = (snd & 0xf);
  if ((jf > 0 && jf < 21)
      && ((js > 1 && js < 8)
	  || (js > 9 && js < 16)
	  || (js > 17 && js < 24)
	  || (js > 25 && js < 30))
      && ((jt > 0 && jt < 18)
	  || (jt > 18 && jt < 30)))
    return 2;

  /* ϼ */
  if ((fst >= 0x81 && fst <= 0xc8)
      && (snd >= 0x41 && snd <= 0xfe))
    return 2;

  return 0;
}
