<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Problmes DNS avec Apache - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.0</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.0</a></div><div id="page-content"><div id="preamble"><h1>Problmes DNS avec Apache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dns-caveats.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>

    <p>L'ensemble de cette page pourrait se rsumer  la phrase&nbsp;: ne 
    jamais configurer Apache de telle sorte qu'il s'appuie sur des 
    rsolutions DNS pour parcourir ses fichiers de configuration. 
    Une telle configuration risque d'engendrer des problmes de 
    fiabilit (le serveur peut ne pas dmarrer), des attaques de type 
    dni et de vol de service (comme par exemple des utilisateurs volant 
    les hits d'autres utilisateurs).</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#example">Un exemple simple</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#denial">Dni de Service</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#main">L'Adresse du "serveur principal"</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#tips">Comment viter ces problmes</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#appendix">Appendice: Perspectives futures</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="example" id="example">Un exemple simple</a></h2>
    

    <div class="example"><p><code>
      &lt;VirtualHost www.abc.dom&gt; <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Pour qu'Apache fonctionne correctement, il a absolument besoin 
    de deux informations pour chacun de ses serveurs virtuels&nbsp;:
    <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code> ainsi qu'au moins une
    adresse IP  laquelle le serveur s'attachera pour rpondre.
    L'exemple ci-dessus ne prcise pas l'adresse IP, si bien qu'Apache doit
    utiliser le DNS pour trouver l'adresse de <code>www.abc.dom</code>. 
    Si, pour une raison ou une autre, le DNS ne fonctionne pas au moment 
    o Apache lit ses fichiers de configuration, le serveur virtuel 
    <strong>ne sera pas configur</strong>. Il sera incapable de rpondre 
    aux requtes. Jusqu' la version 1.2, Apache refusait mme de 
    dmarrer dans ce cas de figure.</p>

    <p>Prenons le cas o l'adresse de <code>www.abc.dom</code> est 10.0.0.1 
    et considrons cet extrait de configuration&nbsp;:</p>

    <div class="example"><p><code>
      &lt;VirtualHost 10.0.0.1&gt; <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Cette fois, Apache a besoin d'utiliser la rsolution DNS 
    inverse pour dterminer le nom <code>ServerName</code> de ce 
    serveur virtuel. Si cette rsolution n'aboutit pas, le serveur 
    virtuel sera partiellement mis hors service (jusqu' la version 
    1.2, Apache refusait mme de dmarrer dans ce cas de figure). Si 
    le serveur virtuel est un serveur bas sur un nom (name-based), 
    il sera totalement hors service, mais s'il s'agit d'un serveur 
    par IP (IP-based), il fonctionnera correctement. Cependant, dans 
    le cas o Apache doit gnrer une adresse complte URL en 
    s'appuyant sur le nom du serveur, il chouera  fournir une 
    adresse valide.</p>

    <p>Voici un extrait de configuration qui rsout ces deux problmes&nbsp;:</p>

    <div class="example"><p><code>
      &lt;VirtualHost 10.0.0.1&gt; <br />
      ServerName www.abc.dom <br />
      ServerAdmin webgirl@abc.dom <br />
      DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt;
    </code></p></div>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="denial" id="denial">Dni de Service</a></h2>
    

    <p>Il existe (au moins) deux problmes possibles de dni de service.
    Les versions d'Apache antrieures  1.2 ne dmarreront pas si 
    l'une des deux requtes DNS cites ci-dessus n'aboutissent pas pour 
    un de vos serveurs virtuels. Dans certains cas, les entres DNS 
    sont hors de contrle de l'administrateur Web&nbsp;; par exemple si 
    <code>abc.dom</code> appartient  un de vos clients qui a la 
    matrise de son propre DNS, celui-ci peut empcher votre serveur 
    Web (avant la version 1.2) de dmarrer, simplement en effaant 
    l'enregistrement <code>www.abc.dom</code> du DNS.</p>
    
    <p>L'autre problme possible est bien plus pernicieux. Dans la 
    configuration suivante&nbsp;:</p>

    <div class="example"><p><code>
      &lt;VirtualHost www.abc.dom&gt; <br />
      &nbsp;&nbsp;ServerAdmin webgirl@abc.dom <br />
      &nbsp;&nbsp;DocumentRoot /www/abc <br />
      &lt;/VirtualHost&gt; <br />
      <br />
      &lt;VirtualHost www.def.dom&gt; <br />
      &nbsp;&nbsp;ServerAdmin webguy@def.dom <br />
      &nbsp;&nbsp;DocumentRoot /www/def <br />
      &lt;/VirtualHost&gt;
    </code></p></div>

    <p>Supposons que <code>www.abc.dom</code> ait l'adresse 10.0.0.1, 
    et que <code>www.def.dom</code> ait l'adresse 10.0.0.2. Supposons 
    galement que <code>def.com</code> ait la main sur son DNS. 
    Cette configuration peut permettre  <code>def.dom</code> de 
    dtourner vers son serveur tout le trafic destin  
    <code>abc.dom</code>. Pour ce faire, il doit simplement
    positionner le champ DNS de <code>www.def.dom</code> sur 10.0.0.1, 
    et rien ne peut l'empcher de faire, puisqu'il a la main sur 
    son DNS.</p>

    <p>Les requtes  destination de 10.0.0.1 (incluant celles dont 
    l'URL contient <code>http://www.abc.com/tout_et_n_importe_quoi</code>) 
    seront envoyes au serveur virtuel de <code>def.dom</code>. Une 
    bonne comprhension des mcanismes internes d'Apache concernant 
    la gestion des serveur virtuels est requise. 
    <a href="vhosts/details.html">Ce document</a> explique ce 
    fonctionnement.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="main" id="main">L'Adresse du "serveur principal"</a></h2>
    

    <p>L'implmentation du support des serveur virtuels <a href="vhosts/name-based.html">par nom</a> depuis Apache 1.1 suppose
    qu'Apache connaisse la ou les adresse(s) IP sur lesquelles le serveur 
    coute. Pour dterminer cette adresse, Apache utilise soit la 
    directive globale <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code> 
    (si elle est prsente), soit un appel  la fonction C 
    <code>gethostname</code> (cet appel renvoie le mme rsultat 
    que la commande "hostname" entre sur une ligne de commande). 
    Une rsolution DNS est alors effectue sur l'adresse obtenue. 
    Pour l'instant, il n'existe aucun moyen de contourner cette 
    requte DNS.</p>

    <p>Pour se prmunir du cas o cette rsolution DNS chouerait  
    cause de la dfaillance du serveur DNS, le nom d'hte peut tre 
    ajout dans <code>/etc/hosts</code> (il y est probablement dj). 
    Assurez vous que votre machine est configure pour lire ce fichier 
    <code>/etc/hosts</code> en cas de dfaillance du serveur DNS. 
    Pour cela, selon votre systme d'exploitation, il vous faudra configurer 
    <code>/etc/resolv.conf</code> ou <code>/etc/nsswitch.conf</code>.</p>

    <p>Au cas o votre serveur n'a pas besoin de raliser des requtes 
    DNS pour d'autres raisons que de dmarrer Apache, il est possible 
    que vous puissiez vous en sortir en positionnant la variable 
    d'environnement <code>HOSTRESORDER</code> sur "local". Ceci dpend 
    cependant de votre systme d'exploitation et des librairies de 
    rsolution DNS que vous utilisez. Ceci affecte galement le 
    comportement des scripts CGIs,  moins que vous n'utilisiez 
    <code class="module"><a href="./mod/mod_env.html">mod_env</a></code> pour contrler leur environnement. La 
    meilleure solution est de consulter les pages "man" ou les FAQs 
    spcifiques  votre systme d'exploitation.</p>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="tips" id="tips">Comment viter ces problmes</a></h2>
    

    <ul>
      <li>
        spcifier les adresses IP dans les 
        <code class="directive"><a href="./mod/core.html#virtualhost">VirtualHost</a></code>
      </li>

      <li>
        spcifier les adresses IP au moyen de
        <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>
      </li>

      <li>
        s'assurer que tous les serveurs virtuels spcifient explicitement 
        leur <code class="directive"><a href="./mod/core.html#servername">ServerName</a></code>
      </li>

      <li>crer un serveur virtuel <code>&lt;VirtualHost _default_:*&gt;</code>
      qui ne sert aucune page</li>
    </ul>
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="appendix" id="appendix">Appendice: Perspectives futures</a></h2>
    

    <p>Les problmes lis au DNS sont trs indsirables.  partir 
    d'Apache 1.2, nous avons travaill  ce qu'Apache dmarre mme 
    dans le cas o les requtes DNS chouent, mais ce n'est pas 
    forcment la meilleure des solutions. En tous cas, obliger 
    l'administrateur  spcifier explicitement des adresses IP est 
    galement trs indsirable sur le rseau Internet tel qu'il 
    existe actuellement, o le nombre d'adresses IP commence  manquer.</p>
    
    <p>Une rponse possible au problme de vol de trafic dcrit ci-avant
    pourrait tre de raliser une rsolution inverse DNS sur l'adresse IP 
    renvoye par la premire requte, et de comparer les deux noms 
    obtenus -- lorsqu'ils sont diffrents, le serveur virtuel serait 
    dsactiv. Ceci suppose que la configuration pour la rsolution 
    inverse DNS soit faite correctement (c'est une chose  laquelle 
    les administrateurs DNS commencent  s'habituer, en raison de 
    l'utilisation de plus en plus rpandue des requtes DNS 
    "double-reverse" par les serveurs FTP et les filtrages 
    "TCP wrappers").</p>
    
    <p>Dans tous les cas de figures, il ne semble pas possible de 
    dmarrer de faon fiable un serveur virtuel quand la requte 
    DNS a chou,  moins de recourir  l'utilisation d'adresses 
    IP fixes. Des solutions partielles, telles que dsactiver des 
    portions de la configuration selon les tches attribues au 
    serveur Web, risquent d'tre pires que ne pas dmarrer du tout.</p>
    
    <p>Au fur et  mesure que HTTP/1.1 se rpand, et que les navigateurs 
    et les serveurs mandataires envoient l'en-tte <code>Host</code>, 
    il devient possible d'viter compltement l'utilisation de serveurs 
    virtuels par IP. Dans ce cas, les serveurs Web n'ont plus aucun 
    besoin de raliser des requtes DNS lors de leur dmarrage. Au 1er 
    mars 1997, ces fonctionnalits ne sont pas suffisamment dployes pour 
    que des serveurs Web sensibles les mettent en oeuvre (NdT&nbsp;: cette 
    remarque est aujourd'hui compltement dpasse, HTTP/1.1 est 
    dsormais support par l'immense majorit des navigateurs et 
    des serveurs mandataires).</p>
  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/dns-caveats.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/dns-caveats.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/dns-caveats.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/dns-caveats.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/dns-caveats.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/dns-caveats.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2009 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>