/* Copyright (c) 1988 by Carrick Sean Casey. All rights reserved. */

/* connect to a port */

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <strings.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include "ipcf.h"
#include "icb.h"
#include "externs.h"

int	connecttoport (char *host_name, int port_number);

int
connecttoport (char *host_name, int port_number)
{
	struct addrinfo hints, *res, *a;
	char p[10];
	int err, s;

	snprintf(p, 9, "%d", port_number);

	fprintf(stderr,"Trying to connect to port %d of host %s.\n", port_number, host_name);

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;

	err = getaddrinfo(host_name, p, &hints, &res);
        if (err) {
                perror(gai_strerror(err));
		return(-1);
	}
	a = res;
        while (a) {
		if ((s = socket(a->ai_family, a->ai_socktype, a->ai_protocol)) < 0) {
			a = a->ai_next;
			continue;
		}
		if (connect(s, a->ai_addr, a->ai_addrlen) < 0) {
			close(s);
			a = a->ai_next;
			continue;
		}
		break;
        }
	freeaddrinfo(res);
	if (!a) {
		fail = "couldn't connect to server (not running?)";
		fprintf(stderr,"icb: couldn't connect to %s server.\n",host_name);
		return(-1);
	}
		
	/* make it non-blocking */
	if (fcntl(s, F_SETFL, FNDELAY) < 0) {
		fail = "contoport: fcntl";
		close(s);
		return(-1);
	}

	port_fd = s;
	return(0);
}
