/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* parse a line from the user */

#include <stdlib.h>
#include "icb.h"
#include "externs.h"

void	parse (char *s);
static char	*nextword (char *s);

extern Tcl_Interp *interp;

char *argv[10];

void
parse (char *s)
{
	char cmdbuf[1024];
	int result;
	char *line = s;
	char *dbuf = NULL;

	/* see if it's just message text */
	if (*s != gv.cmdchar || (*++s==gv.cmdchar)) {
		send_default(s,1);
		goto endparse;
	}

	/* check to see if it's a shell command */
	/* what a mess, but it works */
	if (*s == '!') {
		char *w;
		s++;

		if (gv.restricted) {
		   putl("[=Error=] c_shell: no shell commands in restricted mode",
		    PL_SCR);
		 goto endparse;
		}

		if ((*s == ' ' || *s == '\t') && ((w = nextword(s)) != NULL)) {
			argv[0] = "c_shell"; argv[1] = w; argv[2] = NULL;
			c_shell(NULL, interp, 2, argv);
		} else if (*s != '\0') {
			argv[0] = "c_shell"; argv[1] = s; argv[2] = NULL;
			c_shell(NULL, interp, 2, argv);
		} else {
			argv[0] = "c_shell"; argv[1] = NULL;
			c_shell(NULL, interp, 1, argv);
		}
		goto endparse;
	}

	/* check to see if it's a tcl special */
	if (wordcmp(s, "tcl") == 0) {
		s += 4;
		strcpy(cmdbuf,s);
	} else {
		/* if not, quote the text */
		quoteify(s, cmdbuf);
	}

	putl(line, PL_LOG);

	/* call TCL to evaluate the string */
	result = Tcl_Eval(interp, cmdbuf);

	/* print the results */
	if (result == TCL_OK) {
		if (*Tcl_GetStringResult(interp) != 0)
			putl(Tcl_GetStringResult(interp), PL_SCR | PL_LOG);
	} else {
		if (Tcl_GetStringResult(interp)) {
			sprintf(mbuf, "[=Error=] %s", Tcl_GetStringResult(interp));
			putl(mbuf, PL_SCR | PL_LOG);
		} else
			putl("[=Error=] Unknown Tcl error", PL_SCR | PL_LOG);
	}

endparse:
	if (dbuf)
		free(dbuf);
	return;
}

/* starting at a word, find the start of the next one */
static char *
nextword (char *s)
{
	while (*s != ' ' && *s != '\t' && *s != '\0') s++;
	while ((*s == ' ' || *s == '\t') && *s != '\0') s++;
	if (*s == '\0')
		return(0);
	else
		return(s);
}
