/* Copyright 1994 by Mark J. Reed */
/* For copying and distribution information, see the file COPYING. */

/* primitive to prompt for old and new passwords and change them
  (VMS server) */

#include <pwd.h>
#include <stdlib.h>
#include <unistd.h>
#include "icb.h"
#include "externs.h"

int	s_chpw (TARGLIST);

int
s_chpw (TARGLIST)
{
	static char *usage = "usage: s_chpw [old] [new]";
	char old[64], new1[64], new2[64];
	int match;
	char message[256];

	if (argc > 3 || argc < 1)
		TRETURNERR(usage)

	if (argc > 1 && argv[1][0])
		strcpy(old, argv[1]);
	else
		strcpy(old, (char *) getpass ("Enter old password:"));

	if (argc > 2)
		strcpy(new1, argv[2]);
	else
	{
		match = 1;
		while (match)
		{
			strcpy(new1, (char *) getpass("Enter new password:"));
			strcpy(new2, (char *) getpass("Re-enter new password:"));
			if ((match = strcmp(new1,new2)) != 0)
				putl("They don't match; try again", PL_SCR);
		}
	}
	sprintf(message,"cp %s %s", old, new1);
	sendpersonal("server",message,-1);
	return(TCL_OK);
}
