#
#	Copyright (c) 2001 by Jim Wise
#	For copying and distribution information, see the file COPYING.
#

PREFIX		= /usr/local
BINDIR		= ${PREFIX}/sbin
MANDIR		= ${PREFIX}/man
MAN8DIR		= ${PREFIX}/man/man8
ETCDIR		= ${PREFIX}/etc/icbd

INSTALL		= ../install-sh

WARNS		= -Wall -ansi -pedantic
EXTRAWARNS	= -Wshadow -Wpointer-arith -Werror -Wcast-qual -Wcast-align \
		  -Wstrict-prototypes -Wmissing-prototypes -Wmissing-declarations \
		  -Wnested-externs
# We really should make it possible to build with -Wwrite-strings, as this _will_
# affect portability to some platforms.  The others here are irrelevant.
BADWARNS	= -Wwrite-strings -Wconversion -Waggregate-return -Wredundant-decls
DEBUG		= -DDEBUG -DVERBOSE -g
CFLAGS		= ${WARNS} ${EXTRAWARNS} ${DEBUG}
LDFLAGS		=
LIBS		= -lutil

LINT		= lint
LFLAGS		= ${DEBUG} -Habcnrsuxz -w
MAKEDEPEND	= mkdep
DEPENDFLAGS	=
