/* Copyright 1991 by John Atwood deVries II. */
/* $Id: s_person.c,v 1.11 2001/10/30 05:09:04 jwise Exp $ */
/* For copying and distribution information, see the file COPYING. */

/* primitive to send a personal message */

#include <stdio.h>
#include "externs.h"

void	s_personal (int, int);

void
s_personal(int n, int argc)
{
	int dest;
	char line[LINE_SIZE];

	if (argc == 2) {
		/* constraints: 
			destination nickname exists */

		if( (dest = find_user(getword(fields[1]))) < 0) {
			/* error - no such nick */
			snprintf(line, LINE_SIZE, "%s not signed on.", getword(fields[1]));
			senderror(n, line);
		} else {
			/* send a message to that nick */
			sendperson(n, dest, get_tail(fields[1]));
			if (u_tab[n].echoback == 2) {
				snprintf(line, LINE_SIZE, "<*->%s*> %s", u_tab[dest].nickname, get_tail(fields[1]));
				sends_cmdout(n, line);
			}
		}
	} else {
                error("personal: wrong number of arguments");
	}
}
