/* Copyright (c) 1990 by Carrick Sean Casey. */
/* $Id: strings.c,v 1.21.4.1 2006/04/30 23:28:07 jwise Exp $ */
/* Modified 1991 by John Atwood deVries II. */
/* For copying and distribution information, see the file COPYING. */

#include <ctype.h>
#include <string.h>
#include "externs.h"

#define OKGROUPCHARS	"-.!'$+,/?_"
#define OKNICKCHARS	"-.!'$+,/?_@"

void	filternickname (char *);
void	filtertext (char *);
void	filtergroupname (char *);
void	lcaseit (char *);
void	ucaseit (char *);
char	*getword (char *);
char	*get_tail (char *);
int	split (char *);
void	add_item (int, char *, char *);

/* replace illegal characters in a nickname */

void
filternickname(char *txt)
{
	for (; *txt != '\0'; txt++) {
		if ((*txt >= 'A' && *txt <= 'Z') ||
		  (*txt >= 'a' && *txt <= 'z') ||
		  (*txt >= '0' && *txt <= '9'))
			continue;
		if (!strchr(OKNICKCHARS, *txt))
		{
			if (*txt == ' ')
				*txt = '_';
			else
				*txt = '?';
		}
	}
}


/* replace illegal characters in a regular line of text */

void
filtertext(char *s)
{
	for (;*s != '\0'; s++)
		if (!(*s >= ' ' && *s < '\177'))
			*s = '?';
}

/* replace illegal characters from a groupname */

void
filtergroupname(char *txt)
{
	for (; *txt != '\0'; txt++) {
		if ((*txt >= 'A' && *txt <= 'Z') ||
		  (*txt >= 'a' && *txt <= 'z') ||
		  (*txt >= '0' && *txt <= '9'))
			continue;
		if (!strchr(OKGROUPCHARS, *txt))
		{
			if (*txt == ' ')
				*txt = '_';
			else
				*txt = '?';
		}
	}
}

#define UC(x) ((x >= 'a' && x <= 'z') ? x & ~040 : x)

/* convert a string to lower case */
void
lcaseit(char *s)
{
	for (; *s; s++)
		*s = tolower((int)*s);
}

/* convert a string to upper case */
void
ucaseit(char *s)
{
	for (; *s; s++)
		*s = toupper((int)*s);
}

char *
getword(char *s)
{
	static char word[64];
	char *w = word;
	while (*s != ' ' && *s != '\t' && *s != '\0' && ((w - word) < (64-1)))
		*w++ = *s++;
	*w = '\0';
	return(word);
}

char *
get_tail(char *s)
{
	/* skip first word */
        while (*s != ' ' && *s != '\t' && *s != '\0' )
                s++;
	/* skip white space */
        while ((*s == ' ' || *s == '\t') && *s != '\0' )
                s++;
        return(s);
}

/* Read a line containing zero or more \001s. Split the string into */
/* an array of strings, and return the number of fields found. */

int
split(char *s)
{
	char *p = s;
	int i = 0;

	fields[i] = s;
	for(;;) {
		i++;

		/* find delim or EOS */
		while(*p != '\001' && *p != '\0') p++;

		if (*p == '\001') {
			*p = '\0';
			if (i >= MAX_FIELDS)
				return (MAX_FIELDS);
			fields[i] = ++p;
		} else
			return(i);
	}
}

void
add_item(int n, char *item, char *buf)
{
	if ((strlen(item) + 1) >= ROW_SIZE) {
		error("Attempted to add_item something too big");
		return;
		}
	if ((strlen(item) + strlen(buf) + 1) >= ROW_SIZE) {
		sends_cmdout(n, buf);
		/* do NOT put comma at the beginning of the line */
		if (strcmp(item, ", ") != 0) {
			strlcpy(buf, item, ROW_SIZE);
		} else {
			buf[0] = '\0';
		}
	} else {
		strlcat(buf, item, ROW_SIZE);
	}
}
