/* Copyright (c) 1990 by Carrick Sean Casey. */
/* For copying and distribution information, see the file COPYING. */

/* handle various messages from the server */

#include <stdio.h>
#include "icb.h"
#include "externs.h"
#include "../version.h"
#include <time.h>

/* later, these routines should buffer up text to be sent to the user and */
/* only send them when the user isn't typing */
/* perhaps we should stat the tty and only send when it's been idle for */
/* a second and there is no FIONREAD */
/* DONT stat if there is nothing to send to the tty */

/* open message */

copenmsg(pkt)
char *pkt;
{
	if (split(pkt) != 2) {
		putl("[=Error=] got bad open message packet", PL_ALL);
		return;
	}
	if (ishushed(fields[0]))
		return;

	if (!strcmp(gv.alert,"all"))
	{
		putchar('\007');
		fflush(stdout);
	}

	mbreakprint(0, fields[0], fields[1]);
}

/* personal message */

cpersonalmsg(pkt)
char *pkt;
{
	char string[256];
	char host[256];

	if (split(pkt) != 2) {
		putl("[=Error=] got bad personal message packet", PL_ALL);
		return;
	}

	if (ishushed(fields[0]))
		return;

	if (gv.tabreply)
		histput(fields[0]);

	if (strcmp(gv.alert,"none"))
	{
		putchar('\007');
		fflush(stdout);
	}

	mbreakprint(1, fields[0], fields[1]);
}

/* beep message */

beep(pkt)
char *pkt;
{
	char nick[MAX_NICKLEN+1];

	if (split(pkt) != 1) {
		putl("[=Error=] got bad beep message packet", PL_ALL);
		return;
	}

	if (sscanf(fields[0],"%s (%*s)",nick)!=1)
	{
		strncpy(nick,fields[0],MAX_NICKLEN);
		nick[MAX_NICKLEN]='\0';
	}

	if (ishushed(nick))
		return;

	if (gv.beeps)
		sprintf(mbuf, "%c[=Beep!=] %s sent you a beep.",
		  '\007', fields[0]);
	else
		sprintf(mbuf, "[=Beep!=] %s sent you a beep.", fields[0]);
	putl(mbuf, PL_SCR);

	/* logs and review buffers don't get audible beeps */
	sprintf(mbuf, "[=Beep!=] %s sent you a beep.", fields[0]);
	putl(mbuf, (PL_BUF | PL_LOG));
	if (gv.tabreply)
		histput(nick);

}

/* "please drop the connection" message */

exitmsg()
{
	icbexit();
}


/* protocol version message */

protomsg(pkt)
char *pkt;
{
	char *p;
	int proto_level;

	if (split(pkt) != 3) {
		putl("[=Error=] got bad proto message packet", PL_ALL);
		return;
	}

	proto_level = atoi(fields[0]);
	if (PROTO_LEVEL != proto_level) {
	  fprintf(stderr,
	    "\r\nThis forum client does not know the same protocol as\r\n");
	  fprintf(stderr,
	    "the server. I know protocol level %d and the server",PROTO_LEVEL);
	  fprintf(stderr,
	    " is at\r\nlevel %d.\r\n", proto_level);
	  fprintf(stderr,
	    "I am proceeding, but you may get weird results.\r\n\n");
	}

	if (!whoflg) {
		sprintf(mbuf, "Connected to the %s ICB server (%s).",
		  fields[1], fields[2]);
		putl(mbuf, PL_SCR);
	}

	if (whoflg)
		/* we want a who */
		sendlogin(myloginid, mynick, mygroup, "w", mypass);
	else
	{
		/* we want to log in */
		sendlogin(myloginid, mynick, mygroup, "login", mypass);

	tclreadicbrc();
	sprintf(mbuf,"Type %chelp for help.\n", gv.cmdchar);
	putl(mbuf,PL_SCR);
	}

	/* clobber the password */
	for (p = mypass; *p != '\0'; p++)
		*p = '\0';
}


/* server is telling us we are logged in */

loginokmsg(pkt)
char *pkt;
{
	connected = 1;
}

/* system status update message */

statusmsg(pkt)
char *pkt;
{
	if (split(pkt) != 2) {
		putl("[=Error=] got bad status message packet", PL_ALL);
		return;
	}

	if (!strcmp(fields[0], "Register") && gv.autoregister)
	{
		regnick((char *)0);
		return;
	}
		
	if (!strcmp(fields[0], "Pass"))
	{
		if (!strncmp(fields[1], "Password changed to", 19))
		{
			putl("[=Pass=] Password successfully changed", PL_ALL);
			return;
		}
		else if (!strncmp(fields[1], "Password set to", 15))
		{
			putl("[=Pass=] Password set", PL_ALL);
			return;
		}
	}
		
	if (!strcmp(fields[0], "RSVP"))
	{
		char *user;
		if (strncmp(fields[1],"You are",7)==0)	/* Unix server */
		{	
		int i;
			user = fields[1];
			for (i=0; i<7; ++i)
			{
				while (*user++ != ' ');
			}
		}
		else	/* VMS server */
			user = getword(fields[1]);

		if (ishushed(user))
			return;

		if (gv.tabreply)
			histput(user);


	}

	if (!strcmp(gv.alert,"all"))
	{
		putchar('\007');
		fflush(stdout);
	}

	sprintf(mbuf, "[=%s=] %s", fields[0], fields[1]);
	putl(mbuf, PL_ALL);
}


/* command output message */
/* this should eventually parse things according to command requested */

cmdoutmsg(pkt)
char *pkt;
{
	char *idlestr(), *response(), *ampm();

	/* THIS IS REALLY BAD CODING - it should be cleaned up */
	split(pkt);

	if (strcmp(fields[0], "wl") == 0) {

		/* body of a who listing */
		sprintf(mbuf, "  %c%-12s  %s  %s  %s@%s  %s",
			*fields[1] == 'm' ? '*' : ' ',
			fields[2],
			idlestr(fields[3]),
			ampm((time_t)atol(fields[5]), 0),
			fields[6], fields[7], fields[8]);
		putl(mbuf, PL_SCR | PL_LOG);

	} else if (strcmp(fields[0], "gh") == 0) {
		if (m_groupheader)
			/* header for a grouplisting */
			putl("Group     ## S  Moderator    Topic", PL_SCR | PL_LOG);

	} else if (strcmp(fields[0], "wh") == 0) {
		if (m_whoheader)
	     /* header for a who listing */
	     putl("   Nickname        Idle  Sign-On  Account", PL_SCR | PL_LOG);

	} else if (strcmp(fields[0], "wg") == 0) {

		/* group name from a who command */
/*		if (m_whoheader) { */
			if (gv.groupblanks)
			{
				putl("", PL_SL);
			}
			if (*fields[2] == '\0') { 
				sprintf(mbuf, "Group:%s", fields[1]);
				putl(mbuf, PL_SCR | PL_LOG);
			} else {
				sprintf(mbuf2, "Group:%s", fields[1]);
				sprintf(mbuf, "%-11s  %s", mbuf2, fields[2]);
				putl(mbuf, PL_SCR | PL_LOG);
			}
/*		} else {
			if (*fields[2] == '\0')
				putl(fields[1]);
			else {
				sprintf(mbuf, "%s  \"%s\"", fields[1], fields[2]);
				putl(mbuf, PL_SCR | PL_LOG);
			}
		}
*/
	} else if (strcmp(fields[0], "ch") == 0) {
/*		listcommands();*/
	} else if (strcmp(fields[0], "c") == 0) {
		sprintf(mbuf, "%c%s", gv.cmdchar, fields[1]);
		putl(mbuf, PL_SCR | PL_LOG);
	} else
		/* just some generic command output */
		putl(fields[1], PL_SCR | PL_LOG);
}

/* error message */

errormsg(pkt)
char *pkt;
{
	char nick[MAX_NICKLEN+1];
	int index;

	sprintf(mbuf, "[=Error=] %s", pkt);
	putl(mbuf, PL_ALL);

	for 	(index = 0;
		pkt[index] && (!isspace(pkt[index])) && (index < MAX_NICKLEN);
	 	++index)
	{
		nick[index]=pkt[index];
	}
	nick[index]='\0';
		
	if (!strncmp(pkt+index, " not logged on", 14) ||
	    !strncmp(pkt+index, " is not logged on", 17) ||
	    !strncmp(pkt+index, " not signed on", 14))
	{
		if (gv.autodel)
			histdel(nick);
	}
}


/* important system message */

importantmsg(pkt)
char *pkt;
{
	if (split(pkt) != 2) {
		putl("[=Error=] got bad \"important\" message packet", PL_ALL);
		return;
	}
	sprintf(mbuf, "\007[=%s=] %s", fields[0], fields[1]);
	putl(mbuf, PL_ALL);
}

/* THIS STUFF NEEDS TO BE MOVED! */

/* return a string indicating idle time */

char *
idlestr(num)
char *num;
{
	int seconds = atoi(num);
	static char idletime[8];
	int hours, minutes;

	if (seconds < 60)
		sprintf(idletime, "%6s", "-");
	else if (seconds < 3600)
		sprintf(idletime, "%5dm", seconds / 60 );
	else
	{
		hours = seconds/3600;
		minutes = (seconds - hours * 3600)/60;
		sprintf(idletime, "%2dh%2dm", hours, minutes);
	}
	return idletime;
}


/* return a string indicating response time */

char *
response(num)
char *num;
{
	int secs = atoi(num);
	static char rtime[8];

	if (secs >= 2) {
		sprintf(rtime, " %2ds", secs);
		return(rtime);
	} else
		return("   -");
}

/* return a time, i.e "7:45pm" */


char *
ampm(secs, style)
time_t secs;
int style;
{
	struct tm *t, *localtime();
	static char timestr[12];
	int hr, mn;

	t = localtime(&secs);
	hr = t->tm_hour;
	mn = t->tm_min;

	if (style) {
		sprintf(timestr, "%02d:%02d", hr, mn);
		return(timestr);
	}

	if (hr >= 12)
		sprintf(timestr, "%2d:%02dpm", (hr > 12) ? hr - 12 : hr, mn);
	else if (hr > 0)
		sprintf(timestr, "%2d:%02dam", hr, mn);
	else 
		sprintf(timestr, "12:%02dam", mn);

	return(timestr);
}
