#ifndef BASE_ARRAY_H
#define BASE_ARRAY_H

///@name array
//@{

#define ARRAY_DEFAULTSTEP 64

/**
This is a handle to an array. <P>
Specialized arrays that are based on this array should use a structure like this: <P>
<CODE>
typedef struct CustomDataArrayHandle {<BR>
	int size;<BR>
	CustomData *data;<BR>
} CustomDataArrayHandle;<BR>
</CODE>

*/
typedef struct ArrayHandle {
//the first two should always remain here in this order.
///The number of elements currently in use.
	int size;
///pointer to the data in the array
	void *data;

///The number of bytes in an element of the array.
	int elementSize;
///How many elements to add to the max every time we need more room.
	int elementStep;
///The current maximum number of elements that the array can hold.
	int maxElements;
///Pointer to a blank element this is copied into every new element.
	void *blankElement;
///pointer to a function of the form    void xxx(void *data)
	void (*deleteFunction)(void *);
///pointer to a function of the form    void xxx(void *data)
	void (*createFunction)(void *);
} ArrayHandle;

typedef void (*ArrayFuncCreate)(void *);
typedef void (*ArrayFuncDelete)(void *);

ArrayHandle *arrayMake(int eSize, int eStep, void *blank, void (*createfunction)(void *), void (*deletefunction)(void *));
void arrayFree(ArrayHandle *array);
void *arrayAddElements(ArrayHandle *array, int num);
void *arrayDeleteElements(ArrayHandle *array, int num);

void *arrayInsert(ArrayHandle *array, int first, int count);
void *arrayDelete(ArrayHandle *array, int first, int count);


//internal functions
void arrayNuke(ArrayHandle *array);
void arrayResize(ArrayHandle *array, int newmax);


//@}

#endif //BASE_ARRAY_H
