#ifndef BASE_DBLOCK_H
#define BASE_DBLOCK_H

///@name dblock
//@{

/**
 * Structure for hold arbitary blocks of data. <P>
<B>Basic functions: </B><BR>
\Ref{dblockMake} 
\Ref{dblockFree}
\Ref{dblockResize}
\Ref{dblockExpand}
<P>
<B>Other creation functions: </B><BR>
\Ref{dblockEmpty}
\Ref{dblockCopy}
\Ref{dblockCopyPart}
\Ref{dblockCopyBuffer}
<P>
<B>Manipulation functions: </B><BR>
\Ref{dblockClear}
\Ref{dblockCrop}
\Ref{dblockDelete}
\Ref{dblockDeleteNoShrink}
<P>
\Ref{dblockInsertBuffer}
\Ref{dblockInsertPart}
\Ref{dblockInsertBlock}
<P>
\Ref{dblockAppendBlock}
\Ref{dblockAppendBlock2}
\Ref{dblockAppendBuffer}
\Ref{dblockAppendByte}
<P>
\Ref{dblockMove}
\Ref{dblockMoveAll}
<P>
<B>String functions: </B><BR>
\Ref{stringToDBlock}
\Ref{dblockAppendString}
\Ref{dblockGetString}
\Ref{dblockToStringKeep}
\Ref{dblockToString}
<P>
<B>Other functions: </B><BR>
\Ref{dblockWriteInt}
\Ref{dblockReadInt}
<P>
 */

#include "misc/compat.h"

typedef struct DataBlock {
///the current size of data[]		
		int maxSize;
///the amount actually used
		int size;
/**
This is where data actually begins. 
Ideally should be data[] but that is non-standard and non-portable.
*/
		uint8 data[1];
} DataBlock;




DataBlock *dblockMake(int length, int initlength, char *subgroup);
DataBlock *dblockResize(DataBlock *db, int newmaxlength);
void dblockFree(DataBlock *db);
DataBlock *dblockEmpty(char *subgroup);
DataBlock *dblockExpand(DataBlock *db, int newlength);
DataBlock *dblockCopy(DataBlock *db);
DataBlock *dblockCopyPart(DataBlock *db, int start, int length);

DataBlock *dblockClear(DataBlock *db);
DataBlock *dblockCrop(DataBlock *db, int start, int length);
DataBlock *dblockDelete(DataBlock *db, int start, int length);
DataBlock *dblockDeleteNoShrink(DataBlock *db, int start, int length);

DataBlock *dblockInsertBuffer(DataBlock *db, int dststart, char *srcbuffer, int srcstart, int length);
DataBlock *dblockInsertPart(DataBlock *db, int dststart, DataBlock *dbs, int srcstart, int length);
DataBlock *dblockInsertBlock(DataBlock *db, int dststart, DataBlock *dbs);

DataBlock *dblockAppendBlock(DataBlock *db, DataBlock *dbs);
DataBlock *dblockAppendBlock2(DataBlock *dbs, DataBlock *db);
DataBlock *dblockAppendBuffer(DataBlock *db, char *buffer, int start, int length);
DataBlock *dblockAppendByte(DataBlock *db, char byt);

DataBlock *dblockMove(DataBlock *db, DataBlock *dbs, int length);
DataBlock *dblockMoveAll(DataBlock *db, DataBlock *dbs);

DataBlock *dblockCopyBuffer(char *srcbuffer, int start, int length, char *subgroup);
DataBlock *stringToDBlock(char *srcbuffer, char *subgroup);
DataBlock *dblockAppendString(DataBlock *db, char *srcbuffer);
char *dblockGetString(DataBlock *db);
char *dblockToStringKeep(DataBlock *db);
char *dblockToString(DataBlock *db);

DataBlock *dblockWriteInt(DataBlock *db, int value, int bytes);
int dblockReadInt(DataBlock *db, int bytes);


//@}

#endif //BASE_DBLOCK_H
