#ifndef BASE_LOGGER_H
#define BASE_LOGGER_H

#define LOG_NONE 0
#define LOG_ERROR 1
#define LOG_NORMAL 2
#define LOG_MINOR 3
#define LOG_DEBUG 4
#define LOG_DEBUG_MEM 5
#define LOG_DEBUG_TRAFFIC 6
#define LOG_DEBUG_SPAM 7
#define LOG_DEBUG_KEY 8

#define LOGSTRING(x, y) if(verbosity >= x) {logstring(x, y);}

//these macros are mainly for the debug and minor message levels to avoid 
// excess string operations. Which could happen very often at debug and minor levels.
#define LOGDEBUGTRAFFIC(x) LOGSTRING(LOG_DEBUG_TRAFFIC, x)
#define LOGDEBUGSPAM(x) LOGSTRING(LOG_DEBUG_SPAM, x)
#define LOGDEBUGKEY(x) LOGSTRING(LOG_DEBUG_KEY, x)
#define LOGDEBUG(x) LOGSTRING(LOG_DEBUG, x)
#define LOGMINOR(x) LOGSTRING(LOG_MINOR, x)
#define LOGNORMAL(x) LOGSTRING(LOG_NORMAL, x)
#define LOGERROR(x) LOGSTRING(LOG_ERROR, x)
#define LOGNONE(x) LOGSTRING(LOG_NONE, x)


#define LOGMEMDUMP() if(verbosity >= LOG_DEBUG_MEM) {memDump();}

#include "base/str.h"

#define DEFAULT_LOGFILE "@iip.log"
extern int verbosity;
extern char *logfilename;

extern int quietconsole;

extern int logsafemode;

void setVerbosity(int v);

void setLogFileName(char *filename);

void exitLog(void);
void initLog(void);

void logWriteLine(char *message);
void logmsgraw(char *message);
void logmsgsafe(char *message);
void logmsg(int verblevel, char *message);
void logstring(int verblevel, char *message);


#endif //BASE_LOGGER_H
