#ifndef BASE_STRARRAY_H
#define BASE_STRARRAY_H

typedef struct StringPair {
	char *key;
	char *val;
} StringPair;

typedef struct StringPairArrayHandle {
	int size;
	StringPair *data;
} StringPairArrayHandle;

typedef struct StringArrayHandle {
	int size;
	char **data;
} StringArrayHandle;

typedef struct StringIntPair {
	char *key;
	int val;
} StringIntPair;


//StringArray functions
//StringArrayHandle *makeStringArray(void);
//void freeStringArray(StringArrayHandle *array);
StringArrayHandle *saMake(void);
void saFree(StringArrayHandle *array);
StringArrayHandle *saCopy(StringArrayHandle *sa);
void saDeleteMany(StringArrayHandle *array, int first, int count);
void saDelete(StringArrayHandle *array, int i);
void saExpand(StringArrayHandle *array, int count);
void saAppend(StringArrayHandle *array, char *str);
void saAppendCopy(StringArrayHandle *array, char *str);
StringArrayHandle *saMakeFromSplitString(char *instring, char *splitstring);
char *saImplode(StringArrayHandle *sa, char *sep);
int saMatchAny(StringArrayHandle *sa1, StringArrayHandle *sa2);
void saTrim(StringArrayHandle *sa, char *what);
//internal
void saStringFree(char **str);


//StringPair functions
StringPair stringPairCopy(StringPair *sp);
void stringPairFree(StringPair *sp);
StringPair stringPairMake(char *key, char *val);
StringPair stringPairMakeCopy(char *key, char *val);

//StringPair array functions
//StringPairArrayHandle *makeStringPairArray(void);
//void freeStringPairArray(StringPairArrayHandle *array);
StringPairArrayHandle *spaMake(void);
void spaFree(StringPairArrayHandle *array);
StringPair spaGet(StringPairArrayHandle *array, int i);
void spaSet(StringPairArrayHandle *array, StringPair sp, int i);
void spaSetCopy(StringPairArrayHandle *array, StringPair sp, int i);
void spaDeleteMany(StringPairArrayHandle *array, int first, int count);
void spaDelete(StringPairArrayHandle *array, int i);
void spaExpand(StringPairArrayHandle *array, int count);
void spaAppend(StringPairArrayHandle *array, StringPair sp);
void spaAppendCopy(StringPairArrayHandle *array, StringPair sp);

//StringPairInt functions
int stringIntPairSearch(StringIntPair *array, char *match);

#endif //BASE_STRARRAY_H
