
#include "misc/compat.h"

#ifdef _WINDOZE_
#include <sys/timeb.h>
#else
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>
#endif

#include "base/time.h"

unsigned long timeGetTicks(void) {
        unsigned long t;
#ifdef _WINDOZE_
        struct timeb tb;
        ftime((void *)&tb);
        t = tb.time * (unsigned long)1000000 + tb.millitm * 1000;
#else
        struct timeval tv;
        gettimeofday(&tv, NULL);
        t = tv.tv_sec * (unsigned long)1000000 + tv.tv_usec;
#endif
        return t;
}
