#ifndef CRYPT_ARCFOUR_H
#define CRYPT_ARCFOUR_H

#include "misc/compat.h"

typedef struct ArcfourContext {
	uint8 S[256];
	//uint8 K[256];
	uint8 i;
	uint8 j;
	uint8 ki;
	uint8 kj;
} ArcfourContext;


ArcfourContext *arcfourMake(void);
void arcfourFree(ArcfourContext *a4);
void arcfourReset(ArcfourContext *a4);
void arcfourCrypt(ArcfourContext *a4, uint8 *buffer, int length);
void arcfourBuffer(ArcfourContext *a4, uint8 *buffer, int length);
void arcfourKey(ArcfourContext *a4, uint8 *buffer, int keylength);
void arcfourAddKey(ArcfourContext *a4, uint8 *buffer, int keylength);



#endif //CRYPT_ARCFOUR_H
