#ifndef CRYPT_ENTROPY_H
#define CRYPT_ENTROPY_H
	
///@name entropy
//@{

#include "misc/compat.h"
#include "crypt/sha1.h"
#include "base/dblock.h"

/**
Structure for holding an entropy pool.
*/
typedef struct EntropyPool {
///The hash context for this entropy pool.
	Sha1Contex Sha1;
///Temporary buffer for adding integers.
	uint8 tmp[sizeof(int)];
///Number of bits worth of entropy that have been put into this pool.
	int PoolSize;
} EntropyPool;



EntropyPool *entropyMake(void);
void entropyFree(EntropyPool *ep);
void entropyAddInt(EntropyPool *ep, int value, int bits);
void entropyAddBuffer(EntropyPool *ep, uint8 *buffer, int length, int bits);
void entropyAddDBlock(EntropyPool *ep, DataBlock *db, int bits);
DataBlock *entropyGetDigest(EntropyPool *ep, DataBlock *db);

//@}

#endif //CRYPT_ENTROPY_H
