#ifndef CRYPT_RAND_KEY_H
#define CRYPT_RAND_KEY_H

#include "crypt/sha1.h"
#include "base/dblock.h"
#include "crypt/blowfish.h"

#define RANDOM_KEY_LENGTH 20 //XTEA_KEY_LENGTH
#define RANDOM_KEY_BLOCK_LENGTH BLOWFISH_BLOCK_LENGTH//XTEA_BLOCK_LENGTH

#define RANDOM_KEY_PG 10 //maximum outputs before the generator key is changed

typedef struct RandomKey {
	Sha1Contex Sha1;
	DataBlock *key;
	DataBlock *output;
	DataBlock *counter;
	BlowfishContext *blowfish;
	int outputoffset;
	int outputcounter;
} RandomKey;


RandomKey *randomkeyMake(void);
void randomkeyMakeKey(RandomKey *rk, DataBlock *seed);
void randomkeyRekey(RandomKey *rk);
void randomkeyCounterIncrement(RandomKey *rk);
void randomkeyGateKey(RandomKey *rk);
void randomkeyGenerateOutput(RandomKey *rk);
void randomkeyGetBuffer(RandomKey *rk, uint8 *buffer, int length);

#endif //CRYPT_RAND_KEY_H

