#ifndef NET_SOCKSERV_H
#define NET_SOCKSERV_H

#include "net/sock.h"



typedef struct SockArrayHandle {
	int	size;
	SockHandle **data;
} SockArrayHandle;


extern SockArrayHandle *SocksListening;
extern SockArrayHandle *SocksOpen;


void sockservInit(void (*addfunc)(SockHandle *, int *));
void sockservPoll(int shortdelay);

void sockservAddSock(SockArrayHandle *sah, SockHandle *sh);
void sockservAddOpen(SockHandle *sh);
void sockservAddListening(SockHandle *sh);

void sockservProcessOpen(void);
void sockservProcessListening(void);
void sockservProcess(int shortdelay);

SockHandle *sockservConnect(void);
SockHandle *sockservListen(NodeRef *nr);
int sockservStartListen(void);


//internal functions
NodeRef *sockservPickNode(void);


#endif //NET_SOCKSERV_H
