#ifndef PIPE_CLOSDLAY_H
#define PIPE_CLOSDLAY_H

#include "pipe/pipe.h"
#include <time.h>

typedef struct PipeCloseDelay {
	Pipe	IOPipe;
	time_t	closedtime;
	int	delay;
} PipeCloseDelay;

#define BLANKPIPECLOSEDELAY {BLANKPIPE_PIPE, 0, 0}


Pipe *pipeclosedelayMake(char *pipename, char *options);
void pipeclosedelayFree(PipeCloseDelay *ps);
void pipeclosedelayRead(PipeCloseDelay *thispipe, Pipe **errPipe);
void pipeclosedelayWrite(PipeCloseDelay *thispipe, Pipe **errPipe);
void pipeclosedelayAttach(PipeCloseDelay *thispipe);
void pipeclosedelayDetach(PipeCloseDelay *thispipe);
void pipeclosedelayClose(PipeCloseDelay *thispipe);
void pipeclosedelayStatus(PipeCloseDelay *thispipe, int *status);

extern int closedelay;

#endif //PIPE_CLOSDLAY_H


