//
//p-dummy.c
//
//This is dummy pipe. It will just pass data along doing no filter/processing.
//
//This file can be used as a template for other protocols.
//
//
//-UserX 2001/12/06

#include <stdlib.h>
#include <string.h>

#include "base/dblock.h"
#include "base/mem.h"
#include "base/str.h"
#include "pipe/dummy.h"
#include "base/logger.h"

PipeDummy blankpipedummy = BLANKPIPEDUMMY;

Pipe *pipedummyMake(char *pipename, char *options) {
	PipeDummy *thispipe = memCopy(&blankpipedummy, sizeof(PipeDummy), "PipeDummy", NULL);//xiclone(&blankpipedummy, sizeof(PipeDummy));
	pipeInitFunctions((Pipe *) thispipe, 
			(PipeFuncIn) pipedummyRead, (PipeFuncOut) pipedummyWrite, 
			(PipeFuncAttach) pipedummyAttach, (PipeFuncDetach) pipedummyDetach, 
			(PipeFuncClose) pipedummyClose, (PipeFuncStatus) pipedummyStatus);
	pipeInit((Pipe *) thispipe);
	thispipe->IOPipe.status |= PSTATUS_READY;
	return (Pipe *)thispipe;
}

void pipedummyFree(PipeDummy *thispipe) {
	pipeFree(&thispipe->IOPipe);
	memFree(thispipe);//xifree(thispipe);
}

void pipedummyRead(PipeDummy *thispipe, Pipe **errPipe) {
	*errPipe = pipeGenericRead(thispipe->IOPipe.backPipe);
	if(*errPipe == NULL) {
		LOGDEBUGTRAFFIC(stringJoinMany(
				"pipedummyRead: ",
				ptrToString(thispipe),
				", read bytes:",
				intToHexString(thispipe->IOPipe.backPipe->inBuffer->size),
			NULL));
		thispipe->IOPipe.inBuffer = dblockMoveAll(thispipe->IOPipe.inBuffer, thispipe->IOPipe.backPipe->inBuffer);
	}
}

void pipedummyWrite(PipeDummy *thispipe, Pipe **errPipe) {
	LOGDEBUGTRAFFIC(stringJoinMany(
			"pipedummyWrite: ",
			ptrToString(thispipe),
			", write bytes:",
			intToHexString(thispipe->IOPipe.outBuffer->size),
		NULL));
	thispipe->IOPipe.backPipe->outBuffer = dblockMoveAll(thispipe->IOPipe.backPipe->outBuffer, thispipe->IOPipe.outBuffer);
	*errPipe = pipeGenericWrite(thispipe->IOPipe.backPipe);
}


void pipedummyAttach(PipeDummy *thispipe) {

}

void pipedummyDetach(PipeDummy *thispipe) {
	pipedummyFree(thispipe);
}

void pipedummyClose(PipeDummy *thispipe) {
}

void pipedummyStatus(PipeDummy *thispipe, int *status) {
	//*status &= ~PSTATUS_READ;
}
