#ifndef PIPE_SPURT_H
#define PIPE_SPURT_H

#include "pipe/pipe.h"
#include <time.h>

typedef struct PipeSpurt {
	Pipe	IOPipe;
	//int inHandshake;
	//int outHandshake;
	int readSpurt; //number of bytes waiting for.
	clock_t nextSpurt;	//time of next spurt
	int nextSpurtLength;	//number of bytes to put in it.
} PipeSpurt;

#define BANDWIDTHCOUNT_MAX 10  //maximum number of seconds of backlog there can be.

#define BLANKPIPESPURT {BLANKPIPE_PIPE, 0, 0, 0}



Pipe *pipespurtMake(char *pipename, char *options);
void pipespurtFree(PipeSpurt *ps);
void pipespurtRead(PipeSpurt *thispipe, Pipe **errPipe);
void pipespurtWrite(PipeSpurt *thispipe, Pipe **errPipe);
void pipespurtAttach(PipeSpurt *thispipe);
void pipespurtDetach(PipeSpurt *thispipe);
void pipespurtClose(PipeSpurt *thispipe);
void pipespurtStatus(PipeSpurt *thispipe, int *status);


#endif //PIPE_SPURT_H

