#ifndef UI_UI_WIN_H
#define UI_UI_WIN_H

#include "ui/ui.h"
#include "misc/compat.h"
#include <windows.h>
///@name ui-win
//@{

#define IDBASE 1200

#define BUTTON_WIDTH 120

typedef enum UIWIN_ {
	UIWIN_INACTIVE = 0,
	UIWIN_ACTIVE
} UIWIN_;


typedef struct UIWinWindow {
	UIWindow uiw;

	int entropyneed;
	int entropygot;

	HWND hwnd;
	UIWIN_ active;
	int startradio;
//how many 'windows' controls there are
	int controlcount;

	//LPCTSTR cclass;
	char *cclass;
	DWORD cstyle;
	DWORD cexstyle;

	int x;
	int y;
	int w;
	int h;

} UIWinWindow;

typedef struct UIWinControl {
	UIControl uic;

	HWND hwnd;

	//LPCTSTR cclass;
	char *cclass;
	DWORD cstyle;
	DWORD cexstyle;

	int x;
	int y;
	int w;
	int h;

} UIWinControl;


#define DWORDALIGN(x)  (void *)((((int)x) + 3) & ~3)

UIWindow *uiwinMake(void);

void uiwwInit(UIWinWindow *uidw);
void uiwwFree(UIWinWindow *uidw);
void uiwwRun(UIWinWindow *uidw);
void uiwwAddControl(UIWinWindow *uidw, UIEntry *uie);
void uiwcSetState(UIWinWindow *uidw, int index, int state);
void uiwcSetValue(UIWinWindow *uidw, int index);

void uiwwSizeGroup(UIWinWindow *uiww, int *i, int *x, int *y, int xmargin, int ymargin);

void *uiwwToDialog(UIWinWindow *uiww);

int uiwDialog(char *title, char *text, int type, int defaultchoice);

int uiwGetEntropy(char *title, char *text, int bits);


BOOL APIENTRY uiwwNotify(HWND hwnd, UINT message,WPARAM wParam,LPARAM lParam);
BOOL APIENTRY uiwwcProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

extern HINSTANCE hinst;


//@}

#endif //UI_UI_WIN_H
