/*-
 * Copyright (c) 2003 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipa_ac.h,v 1.2 2011/01/23 18:42:34 simon Exp $
 */

#ifndef IPA_AC_H
#define IPA_AC_H

/*
 * Accounting module, "ac_mod" parameter.
 */
struct ac_mod {
	SLIST_ENTRY(ac_mod) link;	/* For list building. */
	char		*mod_file;	/* Module's file name. */
	dl_handle	mod_handle;	/* dl-handle. */
	unsigned int	mod_ref_count;	/* Reference counter. */
	struct ipa_ac_mod *ipa_ac_mod;	/* Module's struct ipa_ac_mod. */
	struct conf_sect_hash *conf_sect_hash; /* Section hash table. */
	struct conf_param_hash *conf_param_hash; /* Parameter hash table. */
};

/*
 * List of all accounting modules.
 */
SLIST_HEAD(ac_mod_list, ac_mod);

/*
 * One element of "ac_list" parameter.
 */
struct ac_elem {
	STAILQ_ENTRY(ac_elem) link;	/* For list building. */
	const char	*mod_file;	/* ac_mod { mod_file } */
	unsigned int	*mod_ref_count;	/* Ptr to ac_mod { mod_ref_count } */
	const struct ipa_ac_mod *ipa_ac_mod; /* ac_mod { ipa_ac_mod } */
};

/*
 * "ac_list" parameter's elements.
 */
STAILQ_HEAD(ac_list, ac_elem);

/*
 * One "ac_list" parameter.
 */
struct ac_set {
	SLIST_ENTRY(ac_set) link;	/* For list building. */
	struct ac_list	list;		/* All elements in "ac_list". */
};

/*
 * List of all ac_set.
 */
SLIST_HEAD(ac_sets, ac_set);

extern unsigned int nac_mods;

extern signed char debug_ac_null;

extern const struct ac_list *global_ac_list;

extern struct ac_mod_list ac_mod_list;

extern struct ac_sets ac_sets;

extern struct ac_mod *ac_mod_by_prefix(const char *);
extern struct ac_mod *ac_mod_by_name(const char *);

extern void	free_ac_set(struct ac_set *);
extern void	free_ac_lists(void);

extern void	ac_inc_ref_count(const struct ac_list *);
extern int	ac_dec_ref_count(const struct ac_list *);
extern void	ac_set_mod_used(const struct ac_list *);

extern int	pre_init_ac_mods(void);
extern int	init_ac_mods(void);
extern int	deinit_ac_mods(void);

struct rule;
extern int	ac_deinit_rule(const struct rule *);
extern int	ac_set_rule_active(const struct rule *, int);
extern int	ac_get_stat(void);

#ifdef WITH_RULES
extern int	ac_init_statrule(const struct rule *);
#endif

#ifdef WITH_AUTORULES
struct autorule;
extern int	ac_init_autorule(const struct autorule *);
extern int	ac_deinit_autorule(const struct autorule *);
extern int	ac_init_dynrule(const struct autorule *, const struct rule *);
extern int	ac_set_autorule_active(const struct autorule *, int);
#endif

#ifdef WITH_LIMITS
struct limit;
extern int	ac_limit_event(const struct rule *, const struct limit *,
		    unsigned int);
extern int	ac_set_limit_active(const struct rule *, const struct limit *,
		    int);
#endif

#ifdef WITH_THRESHOLDS
struct threshold;
extern int	ac_threshold_event(const struct rule *,
		    const struct threshold *, unsigned int);
extern int	ac_set_threshold_active(const struct rule *,
		    const struct threshold *, int);
#endif

#endif /* !IPA_AC_H */
