/*-
 * Copyright (c) 2005 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipastat_main.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPASTAT_MAIN_H
#define IPASTAT_MAIN_H

#define IPASTAT_NAME	"ipastat"

#ifdef WITH_PTHREAD
# define MEMTYPE_FLAGS	IPA_MEMFUNC_FLAG_PTHREAD
#else
# define MEMTYPE_FLAGS	0
#endif

#define MARRAY_NAME(x)	IPASTAT_NAME ":" #x
#define MZONE_NAME(x)	IPASTAT_NAME ":" #x
#define MTYPE_NAME(x)	IPASTAT_NAME ":m_" #x

extern const char *x_pat;
extern regex_t	x_reg;
extern regex_t	*x_reg_ptr;

enum {
	A_FLAG_ABSENT = 0,
#ifdef WITH_LIMITS
	A_FLAG_LIMITS,
#endif
#ifdef WITH_THRESHOLDS
	A_FLAG_THRESHOLDS,
#endif
	A_FLAG_RULES
};

extern unsigned int a_flag;

extern ipa_mem_type *m_anon;
extern ipa_mem_type *m_result;

extern int	ipastat_main(void);

extern int	deinit_all(void);
extern int	free_all(void);

#endif /* !IPASTAT_MAIN_H */
