/*-
 * Copyright (c) 2005 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  @(#)$Id: ipastat_st.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPASTAT_ST_H
#define IPASTAT_ST_H

/*
 * Statistics module, "st_mod" parameter.
 */
struct st_mod {
	SLIST_ENTRY(st_mod) link;	/* All st_mod list. */
	char		*mod_file;	/* Module's file name. */
	dl_handle	mod_handle;	/* dl-handle. */
	struct ipa_st_mod *ipa_st_mod;	/* Module's struct ipa_st_mod{}. */
	struct conf_sect_hash *conf_sect_hash; /* Section lookup hash. */
	struct conf_param_hash *conf_param_hash; /* Parameter lookup hash. */
};

/*
 * List of all statistics modules.
 */
SLIST_HEAD(st_mod_list, st_mod);

/*
 * One element in "st_list" parameter.
 */
struct st_elem {
	STAILQ_ENTRY(st_elem) link;	/* All elements of one "st_list". */
	const char	*mod_file;	/* The same as st_mod { mod_file } */
	const struct ipa_st_mod *ipa_st_mod; /* st_mod { ipa_st_mod } */
};

/*
 * "st_list" parameter.
 */
STAILQ_HEAD(st_list, st_elem);

/*
 * List of all "st_list" parameters.
 */
struct st_set {
	SLIST_ENTRY(st_set) link;	/* All "st_list" parameters. */
	struct st_list	list;		/* One "st_list" parameter. */
};

/*
 * List of all st_set.
 */
SLIST_HEAD(st_sets, st_set);

/*
 * -s "name1 name2 ..."
 */
struct opt_st {
	STAILQ_ENTRY(opt_st) link;	/* Linked list of all -s ... -s ... */
	char		*st_names;	/* -s "name1 name2 ..." */
	const struct st_list *st_list;	/* Pointer to corresponding st_list. */
};

/*
 * List of all opt_st structures.
 */
STAILQ_HEAD(opt_st_list, opt_st);

extern struct opt_st *cur_opt_st;
extern struct opt_st_list opt_st_list;

extern struct st_mod_list st_mod_list;

extern struct st_sets st_sets;

extern const struct st_list *global_st_list;

extern signed char debug_st_null;

extern struct st_list st_list_null;

extern struct st_mod *st_mod_by_prefix(const char *);
extern struct st_mod *st_mod_by_name(const char *);

extern void	free_st_lists(void);

extern int	pre_init_st_mods(void);
extern int	init_st_mods(void);
extern int	deinit_st_mods(void);

extern int	st_init_rule(const struct rule *);
extern int	st_deinit_rule(const struct rule *);
extern int	st_get_rules_list(const struct st_list *, unsigned int *,
		    struct ipa_entity_desc **);
extern int	st_get_rule_stat(const struct rule *, const ipa_tm *,
		    const ipa_tm *, int, unsigned int *,
		    struct ipa_rule_stat **);
extern int	st_get_rule_info(const struct rule *, char **);

#ifdef WITH_LIMITS
extern int	st_init_limit(const struct rule *, const struct limit *);
extern int	st_deinit_limit(const struct rule *, const struct limit *);
extern int	st_get_limits_list(const struct rule *, unsigned int *,
		    struct ipa_entity_desc **);
extern int	st_get_limit_stat(const struct rule *, const struct limit *,
		    const ipa_tm *, const ipa_tm *, unsigned int *,
		    struct ipa_limit_state **);
extern int	st_get_limit_info(const struct rule *, const struct limit *,
		    char **);
#endif

#ifdef WITH_THRESHOLDS
extern int	st_init_threshold(const struct rule *,
		    const struct threshold *);
extern int	st_deinit_threshold(const struct rule *,
		    const struct threshold *);
extern int	st_get_thresholds_list(const struct rule *, unsigned int *,
		    struct ipa_entity_desc **);
extern int	st_get_threshold_stat(const struct rule *,
		    const struct threshold *, int *reged,
		    struct ipa_threshold_state *);
extern int	st_get_threshold_info(const struct rule *,
		    const struct threshold *, char **);
#endif

extern int	opt_st_add(char *);
extern void	opt_st_free(void);
extern int	opt_st_parse(void);

#endif /* !IPASTAT_ST_H */
