/*-
 * Copyright (c) 2005 Andrey Simonenko
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *   @(#)$Id: ipastat_thresholds.h,v 1.2 2011/01/23 18:42:35 simon Exp $
 */

#ifndef IPASTAT_THRESHOLDS_H
#define IPASTAT_THRESHOLDS_H

#ifdef WITH_THRESHOLDS

#ifndef THRESHOLD_NSIZE
# define THRESHOLD_NSIZE 30
#endif

#ifndef THRESHOLD_NALLOC
# define THRESHOLD_NALLOC 20
#endif

struct rule;
struct opt_rule;

#define THRESHOLD_FREE_NAME	0x01	/* Free 'name' in struct threshold{} */

/*
 * threshold{} section.
 */
struct threshold {
	STAILQ_ENTRY(threshold) link;	/* Link for list of thresholds. */

	char		*name;		/* Name of this threshold. */
	char		*info;		/* Info for this threshold. */
	unsigned int	no;		/* Threshold ordinal number. */

	const struct st_list *st_list;	/* { st_list } */

	unsigned int	free_mask;	/* THRESHOLD_FREE_xxx bits. */

	int		inited;		/* Set if threshold was initialized. */
};

/*
 * List of all thresholds in one rule.
 */
STAILQ_HEAD(thresholds_list, threshold);

/*
 * Threshold in query: -q ... -t <name>
 */
struct opt_threshold {
	STAILQ_ENTRY(opt_threshold) link; /* For list building. */

	const char	*name;		/* -t <name> */
	struct threshold *threshold;	/* Corresponding threshold structure. */

	const struct opt_st *opt_st;	/* Corresponding -s ... */

	int		reged;		/* Set if threshold has state. */
	struct ipa_threshold_state state;/* Threshold state. */
};

/*
 * Several thresholds in query: -q ... -t <name1> -t <name2> ...
 */
STAILQ_HEAD(opt_thresholds, opt_threshold);

extern signed char dynamic_thresholds;

extern ipa_mzone *threshold_mzone;

extern struct threshold *alloc_threshold(void);

extern int	init_thresholds(const struct opt_rule *);
extern int	deinit_thresholds(const struct opt_rule *);

extern void	free_thresholds(struct thresholds_list *);
extern int	copy_thresholds(struct rule *, const struct thresholds_list *);

extern int	opt_threshold_add(const char *);
extern int	opt_thresholds_parse(const struct opt_rule *);
extern void	opt_thresholds_free(const struct opt_thresholds *);

extern struct threshold *threshold_by_name(const struct rule *, const char *);

#endif /* WITH_THRESHOLDS */

extern char	has_opt_thresholds;

#endif /* !IPASTAT_THRESHOLDS_H */
