/*
 * irc.h: header file for all of ircII! 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2009 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$eterna: irc.h,v 1.94 2011/11/15 06:26:31 mrg Exp $
 */

#ifndef __irc_h
#define __irc_h

#define IRCII_COMMENT   "propelling cheese in the 21st century and beyond!"

#define IRCRC_NAME "/.ircrc"
#define IRCQUICK_NAME "/.ircquick"

/*
 * Here you can set the in-line quote character, normally backslash, to
 * whatever you want.  Note that we use two backslashes since a backslash is
 * also C's quote character.  You do not need two of any other character.
 */
#define QUOTE_CHAR '\\'

#include "defs.h"
#include "config.h"

#include <stdio.h>
#include <ctype.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <sys/param.h>

#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */

#ifdef HAVE_SYS_FCNTL_H
# include <sys/fcntl.h>
#endif /* HAVE_SYS_FCNTL_H */
#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef HAVE_SYS_FILE_H
# include <sys/file.h>
#endif /* HAVE_SYS_FILE_H */

#ifdef HAVE_NETDB_H
# include <netdb.h>
#endif /* HAVE_NETDB_H */

#ifdef HAVE_PROCESS_H
# include <process.h>
#endif /* HAVE_PROCESS_H */

#ifdef HAVE_TERMCAP_H
# include <termcap.h>
#endif /* HAVE_TERMCAP_H */

#include <stdarg.h>

#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif /* HAVE_SYS_SELECT_H */

#include "irc_std.h"
#include "debug.h"

/* these define what characters do, colour inverse, underline, bold and all off */
#define COLOUR_TAG	'\003'		/* ^C */
#define REV_TOG		'\026'		/* ^V */
#define UND_TOG		'\037'		/* ^_ */
#define BOLD_TOG	'\002'		/* ^B */
#define ALL_OFF		'\017'		/* ^O */
#define CHARSET_TAG	'\001'		/* internal, should be different than all others */
#define FULL_OFF	'\004'		/* internal, should be different than all others */

#define IRCD_BUFFER_SIZE	1024
#define BIG_BUFFER_SIZE		(IRCD_BUFFER_SIZE * 4)

#ifndef INPUT_BUFFER_SIZE
#define INPUT_BUFFER_SIZE	450
/* was: (IRCD_BUFFER_SIZE / 4)
   256 would be unreasonable limit? 450 sounds good;
   leaves a fair space for the command, channel name, etc., from 512. */
#endif /* INPUT_BUFFER_SIZE */

#include "struct.h"

#ifdef notdef
# define DAEMON_UID 1
#endif

#define NAME_LEN 255
#define REALNAME_LEN 50
#define PATH_LEN 1024

#if defined(__hpux) || defined(hpux) || defined(_HPUX_SOURCE)
# undef HPUX
# define HPUX
# define killpg(pgrp,sig) kill(-pgrp,sig)
#endif /* __hpux || hpux || _HPUX_SOURCE */

/*
 * Lame Linux doesn't define X_OK in a non-broken header file, so
 * we define it here.. 
 */
#if !defined(X_OK)
# define X_OK  1
#endif

#ifdef __BORLANDC__
# define F_OK 0
# define W_OK 2
# define R_OK 4
#endif

#ifdef __osf__
# if __osf__
#  define _BSD
# endif /* __osf__ */
#endif /* __osf__ */

/* systems without getwd() can lose, if this dies */
#if defined(NEED_GETCWD)
# define getcwd(b, c)	getwd(b);
#endif /* NEED_GETCWD */

#ifdef MAIL_DIR
# undef UNIX_MAIL
# define UNIX_MAIL MAIL_DIR
#endif /* MAIL_DIR */

#ifndef MIN
# define MIN(a,b) ((a < b) ? (a) : (b))
#endif /* MIN */

#ifndef MAX
# define MAX(a,b) ((a < b) ? (b) : (a))
#endif /* MAX */

/* flags used by who() and whoreply() for who_mask */
#define WHO_OPS		0x0001
#define WHO_NAME	0x0002
#define WHO_ZERO	0x0004
#define WHO_CHOPS	0x0008
#define WHO_FILE	0x0010
#define WHO_HOST	0x0020
#define WHO_SERVER	0x0040
#define	WHO_HERE	0x0080
#define	WHO_AWAY	0x0100
#define	WHO_NICK	0x0200
#define	WHO_LUSERS	0x0400
#define	WHO_REAL	0x0800

#ifdef ICONV_CONST_ARG2
#define iconv_const const
#else
#define iconv_const
#endif

#ifdef SYSVSIGNALS /* sysv has dumb signals */
#define MY_SIGNAL_REINIT(sig, func, val)	MY_SIGNAL(sig, func, val)
#else
#define MY_SIGNAL_REINIT(sig, func, val)	/* nothing */
#endif /* SYSVSIGNALS */


/*
 * declared in irc.c 
 */
extern	u_char	*cut_buffer;
extern	u_char	oper_command;
extern	int	irc_port;
extern	int	send_text_flag;
extern	int	irc_io_loop;
extern	int	break_io_processing;
extern	int	use_flow_control;
extern	u_char	*joined_nick;
extern	u_char	*public_nick;
extern	u_char	empty_string[];
extern	u_char	*zero;
extern	u_char	*one;

extern	u_char	irc_version[];
extern	u_char	*nickname;
extern	u_char	*ircrc_file;
extern	u_char	*ircquick_file;
extern	u_char	hostname[];
extern	u_char	realname[];
extern	u_char	username[];
extern	u_char	*send_umode;
extern	u_char	*last_notify_nick;
extern	int	away_set;
extern	int	background;
extern	u_char	*my_path;
extern	u_char	*irc_path;
extern	u_char	*irc_lib;
extern	u_char	*args_str;
extern	u_char	*invite_channel;
extern	int	who_mask;
extern	u_char	*who_name;
extern	u_char	*who_host;
extern	u_char	*who_server;
extern	u_char	*who_file;
extern	u_char	*who_nick;
extern	u_char	*who_real;
extern	u_char	*cannot_open;
extern	u_char	*program_name;
extern	int	dumb;
extern	int	use_input;
extern	time_t	idle_time;
extern	int	waiting;
extern	u_char	wait_nick[];
extern	u_char	whois_nick[];
extern	u_char	lame_wait_nick[];
extern	char	**environ;
extern	int	current_numeric;
extern	int	qflag;
extern	int	bflag;
extern	int	tflag;
extern	int	client_default_icb;
extern	u_char	*source_host;
extern	u_char	*dcc_source_host;

/*
 * XXX some of these should move to a new notice.h
 */
	int	irc_io(u_char *, void (*)(u_int, u_char *), int, int);
	void	set_irchost(u_char *);
	void	set_dcchost(u_char *);
	int	wild_match(u_char *, u_char *);
	RETSIGTYPE	irc_exit(void);
	void	beep_em(int);
	void	got_initial_version(u_char *);
	void	maybe_load_ircrc(void);
	void	load_ircrc(void);
	void	load_ircquick(void);
	void	parse_notice(u_char *, u_char **);
	void	irc_quit(u_int, u_char *);
	void	on_signal_occurred(int);

typedef	struct	WhoisStuffStru
{
	u_char	*nick;
	u_char	*user;
	u_char	*host;
	u_char	*channel;
	u_char	*channels;
	u_char	*name;
	u_char	*server;
	u_char	*server_stuff;
	u_char	*away;
	int	oper;
	int	chop;
	int	not_on;
}	WhoisStuff;

/* Moved into here, because some weird CC's can't do (void *) */
typedef	struct	WhoisQueueStru
{
	u_char	*nick;			/* nickname of whois'ed person(s) */
	u_char	*text;			/* additional text */
	int	type;			/* Type of WHOIS queue entry */
	/*
	 * called with func((WhoisStuff *)stuff, nick, text) 
	 */
	void	 (*func)(WhoisStuff *, u_char *, u_char *);
	struct	WhoisQueueStru	*next;	/* next element in queue */
}	WhoisQueue;

char	*getenv(const char *);

#endif /* __irc_h */
