/*
 * screen.h: header for screen.c
 *
 * written by matthew green.
 *
 * Copyright (c) 1993-2008 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * see the copyright file, or type help ircii copyright
 *
 * @(#)$eterna: screen.h,v 1.30 2011/03/01 02:53:51 mrg Exp $
 */

#ifndef __screen_h_
#define __screen_h_

#include "window.h"

#define WAIT_PROMPT_LINE        0x01
#define WAIT_PROMPT_KEY         0x02

/* Stuff for the screen/xterm junk */

#define ST_NOTHING      -1
#define ST_SCREEN       0
#define ST_XTERM        1

/* This is here because it happens in so many places */
#define curr_scr_win	current_screen->current_window

	void	clear_window(Window *);
	void	recalculate_window_positions(void);
	int	output_line(u_char *, u_char **, int);
	void	recalculate_windows(void);
	Window	*create_additional_screen(int);
	void	scroll_window(Window *);
	Window	*new_window(void);
	void	update_all_windows(void);
	void	add_wait_prompt(u_char *, void (*)(u_char *, u_char *), u_char *, int);
	void	clear_all_windows(int);
	void	cursor_in_display(void);
	int	is_cursor_in_display(void);
	void	cursor_not_in_display(void);
	void	set_current_screen(Screen *);
	void	window_redirect(u_char *, int);
	void	redraw_resized(Window *, ShrinkInfo, int);
	void	close_all_screen(void);
	void	scrollback_forwards(u_int, u_char *);
	void	scrollback_backwards(u_int, u_char *);
	void	scrollback_end(u_int, u_char *);
	void	scrollback_start(u_int, u_char *);
	int	check_screen_redirect(u_char *);
	void	kill_screen(Screen *);
	int	is_main_screen(Screen *);
	int	rite(Window *, u_char *, int, int, int, int);
	ShrinkInfo	resize_display(Window *);
	void	redraw_all_windows(void);
	void	add_to_screen(u_char *);
	void	screen_wserv_message(Screen *screen);

extern	Window	*to_window;
extern	Screen	*current_screen;
extern	Screen	*main_screen;
extern	Screen	*last_input_screen;
extern	Screen	*screen_list;

#endif /* __screen_h_ */
