/*
Copyright (c) 2000, Thomas Gagne, tgagne@ix.netcom.com
http://home.netcom.com/~tgagne
*/

#include "isdio.h"
#include "python1.5/Python.h"


static PyObject *attach(PyObject *self, PyObject *args)
{
	int socket;
	char *host, *service, *worker;

	if (!PyArg_ParseTuple(args, "sss", &host, &service, &worker))
		return NULL;

	socket = isdAttach(host, service, worker, 0);

	return Py_BuildValue("i", socket);
}

/*
I wanted this to be named "send()" but it conflicted
with something else more important.
*/
static PyObject *PyIsdSend(PyObject *self, PyObject *args)
{
	int socket;
	char *message, *header;
	int messageLength, headerLength;
	int bytes;

	if (!PyArg_ParseTuple(args, "is#s#", &socket, 
		&message, &messageLength, 
		&header, &headerLength))
		return NULL;

	bytes = isdSend(socket, message, messageLength, (isdHeader *) header);
	return Py_BuildValue("i", bytes);
}

static PyObject *recvHeader(PyObject *self, PyObject *args)
{
	int bytes;
	int socket;
	int headerLength;
	isdHeader header, *pheader;

	if (!PyArg_ParseTuple(args, "is#", &socket, &pheader, &headerLength))
		return NULL;

	bytes = isdRecvHeader(socket, &header);
	memcpy((void *) pheader, (void *) &header, sizeof *pheader);

	return Py_BuildValue("i", bytes);
}

static PyObject *recvAll(PyObject *self, PyObject *args)
{
	int bytes, length;
	int socket;
	char *message;

	if (!PyArg_ParseTuple(args, "is#", &socket, &message, &length))
		return NULL;

	bytes = isdRecvAll(socket, message, length);

	return Py_BuildValue("i", bytes);
}

static PyObject *login(PyObject *self, PyObject *args)
{
	char *hostname, *service;
	int priority;
	int socket;

	if (!PyArg_ParseTuple(args, "zzi", &hostname, &service, &priority)) {
		return NULL;
	}

	socket = isdLogin(hostname, service, priority);

	return Py_BuildValue("i", socket);
}


static PyObject *logout(PyObject *self, PyObject *args)
{
	int socket;

	if (!PyArg_ParseTuple(args, "i", &socket)) {
		return NULL;
	}

	isdLogout(socket);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMethodDef isdio_methods[] = {
	{ "attach", attach, 1, "int socket = attach(string hostname, string servicename, string workerid)" },
	{ "login", login, 1, "int socket = isdLogin(string hostname, string servicename, int priority)" },
	{ "logout", logout, 1, "int result = isdLogout(int socket)" },
	{ "send", PyIsdSend, 1, "int bytes = send(socket, message, header, len)" },
	{ "recvHeader", recvHeader, 1, "int bytes = recvHeader(socket, header)" },
	{ "recvAll", recvAll, 1, "int bytes = recvAll(socket, message, len)" },
	{ NULL, NULL }
};

void initisdio(void)
{
	Py_InitModule("isdio", isdio_methods);
}
