#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "isdio.h"


#ifdef HAVE_W3C_LIBWWW_WWWLIB_H
#include "w3c-libwww/WWWLib.h"
#ifdef LIBWWW_SHARED
#include "HTextImp.h"
#endif
#endif

#define ISDCLIENT_BUFSIZE 4096

int
main(int argc, char **argv)
{

	SOCKET sock;
	int keep = 0, usage = 0, i, firstarg, newsize, size = 0;
	int unescapeURLs = 0, isdDebug = 0;
	long sequence;
	isdHeader header;
	char *msgBuffer, *command = NULL;
	char input[ISDCLIENT_BUFSIZE];
	char *host = NULL, *request, *service = ISDSERVICE;

#ifndef _Windows
	setbuf(stdin, NULL);
#endif

#ifdef HAVEWWW
	HTLibInit(PACKAGE, VERSION);
#endif
/*
   we initialize request here
   because we may be loading it with a -c "command"
 */
	*(request = malloc(size = ISDCLIENT_BUFSIZE)) = 0;

	for (firstarg = 0, i = 1; i < argc && firstarg == 0; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
#ifdef DOTHIS
			case 'c':
				if (argv[i][2])
					command = &argv[i][2];
				else
					// command = argv[++i];	/* note: we're incrementing i */
					command = (argv[++i] == NULL) ? "" : argv[i];
				strcpy(request, command);	/* fill-in the request */
				strcpy(input, "go\n");	/* fake-out the loop */
				break;
#endif
			case 'd':
				isdDebug = 1;
				break;

			case 'h':
				if (argv[i][2])
					host = &argv[i][2];
				else
					host = argv[++i];	/* note: we're incrementing i */
				break;

			case 'k':
				keep = 1;

			case 'u':
				unescapeURLs = 1;
				break;

			default:
				usage = 1;
				break;
			}
		}
		else {
			firstarg = i;
			break;
		}
	}

	if (isdDebug) {
		for (i = 0; i < argc; i++)
			fprintf(stderr, "argv[%d] = [%s]\n", i, argv[i]);
	}

	if (firstarg)
		service = argv[firstarg];

	if ((sock = isdLogin(host, service, 2)) != INVALID_SOCKET) {
		for (sequence = 1;
			 command ? (command != NULL) : (fgets(input, ISDCLIENT_BUFSIZE, stdin) == (char *) input);
			 sequence++) {

			if (strcmp(input, "go\n") == 0) {
				memset((char *) &header, 0, sizeof header);
				header.reply = 1;
				header.error = 0;
				header.more = keep;
				header.sequence = sequence;

#ifdef HAVE_LIBWWW
				if (unescapeURLs)
					HTUnEscape(request);
#endif
				if (isdDebug)
					fprintf(stderr, "isdSend()ing [%s]\n", request);

				if (isdSend(sock, request, -1, &header) != -1) {
					do {
						if (msgBuffer = isdRecv(sock, &header))
							fwrite(msgBuffer, 
								strlen(msgBuffer) < header.len ? 
										strlen(msgBuffer):header.len,
								1, stdout);
						else
							break;
						if (keep && !header.sequence)
							break;
					} while (header.more);
				}
				else
					perror("isdSend()ing");

				*request = 0;
			}
			else {
				newsize = strlen(request) + strlen(input);
				if (newsize > size)
					request = realloc(request, size = newsize);
				strcat(request, input);
			}

			if (command)
				break;
		}
		fflush(stdout);
		isdLogout(sock);
	}
	else
		perror("isdLogin()");

	if (usage)
		fprintf(stderr, "%s [-c command] [-h host] [-k] [servicename]\n", argv[0]);

#ifdef HAVEWWW
	HTLibTerminate();
#endif
	exit(0);

	return 0;
}
